<?php
namespace App\Model\Master\Blogs;
use Illuminate\Database\Eloquent\Model;
use App\Model\Master\Blogs\Tag;
use App\Model\Master\Blogs\Industry;
use Illuminate\Database\Eloquent\SoftDeletes;

class Blog extends Model
{
     use SoftDeletes;
    public $timestamps = true;
    protected $table = "blogs";
    protected $fillable = [
        'user_id',
        'title',
        'slug',
        'content',
        'image',
        'seo_title',
        'seo_description',
        'seo_keywords',
        'is_published',
        'category',
        'categorySlug'

    ];
  public function tags()
    {
        return $this->belongsToMany(Tag::class, 'blog_tag');
    }
 public function industry()
    {
        return $this->belongsTo(Industry::class);
    }
}