<?php
// app/Services/Fast2SmsService.php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class Fast2SmsService
{
    public function send(string $phone, string $message): array
    {
        $response = Http::withHeaders([
            'authorization' => env('FAST2SMS_API_KEY'),
            'Content-Type' => 'application/json',
        ])->post('https://www.fast2sms.com/dev/bulkV2', [
            'message' => $message,
            'language' => 'english',
            'route' => 'q',  // Quick, no DLT
            'numbers' => $phone,
        ]);

        if ($response->successful()) {
            return ['success' => true, 'data' => $response->json()];
        }

        return ['success' => false, 'error' => $response->json('message') ?? 'Failed'];
    }
}