<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateRinglessListHeaderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ringless_list_header', function (Blueprint $table) {
            $table->id();
			$table->integer('list_id');
			$table->string('header');
			$table->string('column_name');
			$table->integer('label_id')->nullable();
			$table->boolean('is_dialing')->default(0);
			$table->boolean('is_deleted')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ringless_list_header');
    }
}
