<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCdrReportSpoofTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cdr_report_spoof', function (Blueprint $table) {
            $table->increments('id');
            $table->unsignedBigInteger('extension')->nullable()->index();
            $table->enum('route', ['IN', 'OUT', 'C2C']);
            $table->enum('type', ['manual', 'dialer', 'predictive_dial', 'outbound_ai', 'c2c'])->default('dialer');
            $table->unsignedBigInteger('number');
            $table->unsignedBigInteger('cli')->nullable();
            $table->string('channel', 255);
            $table->integer('duration')->nullable();
            $table->integer('unit_minute')->nullable();
            $table->decimal('charge', 8, 4)->unsigned()->nullable();
            $table->timestamp('start_time')->useCurrent()->index();
            $table->timestamp('end_time')->nullable();
            $table->string('call_recording', 255)->nullable();
            $table->integer('campaign_id')->nullable()->index();
            $table->integer('disposition_id')->nullable();
            $table->integer('lead_id')->nullable();
            $table->integer('dnis')->nullable();
            $table->tinyInteger('isFree')->unsigned()->default(0);
            $table->string('currency_code', 3)->nullable();
            $table->integer('client_package_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('billable_minutes')->nullable();
            $table->decimal('billable_charge', 8, 4)->unsigned()->nullable();
            $table->string('area_code', 20)->nullable();
            $table->enum('amd_status', ['0', '1'])->default('0');
            $table->string('amd_detection', 255)->nullable();
            $table->integer('country_code')->default(1);
            $table->string('call_matrix_reference_id', 255)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cdr_report_spoof');
    }
}
