<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmailLogsSendgridTable extends Migration
{
    public function up()
    {
        Schema::create('email_logs_sendgrid', function (Blueprint $table) {
            $table->id();
            $table->string('sg_message_id')->nullable()->index();
            $table->string('to_email')->nullable()->index();
            $table->string('subject')->nullable();
            $table->text('body')->nullable();
            $table->string('status')->default('queued')->index();
            $table->string('custom_ref', 100)->nullable();
            $table->unsignedBigInteger('lead_id')->nullable()->index();
            $table->timestamps();

            // Optional foreign key if you have leads table:
            // $table->foreign('lead_id')->references('id')->on('leads')->onDelete('set null');
        });
    }

    public function down()
    {
        Schema::dropIfExists('email_logs_sendgrid');
    }
}
