<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('prompt_functions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('prompt_id');
            $table->unsignedBigInteger('user_id');
            $table->enum('type', ['sms', 'call']);
            $table->string('name'); // slug format enforced in controller
            $table->text('message')->nullable(); // for sms
            $table->string('phone')->nullable(); // for call
            $table->timestamps();

            $table->foreign('prompt_id')->references('id')->on('prompts')->onDelete('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('prompt_functions');
    }
};
