<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cdr_archive_ai', function (Blueprint $table) {
            $table->id();
            $table->string('extension')->nullable();
            $table->enum('route', ['IN', 'OUT', 'C2C']);
            $table->enum('type', ['manual', 'dialer', 'predictive_dial', 'outbound_ai','c2c'])->default('dialer');
            $table->unsignedBigInteger('number');
            $table->unsignedBigInteger('cli')->nullable();
            $table->string('channel')->nullable();
            $table->integer('duration')->nullable();
            $table->integer('unit_minute')->nullable();
            $table->decimal('charge', 8, 4)->nullable();
            $table->timestamp('start_time')->useCurrent();
            $table->timestamp('end_time')->nullable();
            $table->string('call_recording')->nullable();
            $table->integer('campaign_id')->nullable();
            $table->integer('disposition_id')->nullable();
            $table->integer('lead_id')->nullable();
            $table->integer('dnis')->nullable();
            $table->tinyInteger('isFree')->default(0)->comment('0–No, 1-Yes');
            $table->string('currency_code', 10)->nullable()->default('ISO 4217');
            $table->integer('client_package_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->integer('billable_minutes')->nullable()->comment('Number of minutes billed');
            $table->decimal('billable_charge', 8, 4)->nullable();
            $table->string('area_code', 20)->nullable();
            $table->enum('amd_status', ['0', '1'])->default('0');
            $table->string('amd_detection')->nullable();
            $table->integer('country_code')->default(1);
            $table->string('call_matrix_reference_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cdr_archive_ai');
    }
};
