<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('prompt_functions', function (Blueprint $table) {
            $table->string('api_method', 10)->nullable()->after('curl_response');
            $table->text('api_url')->nullable()->after('api_method');
            $table->longText('api_body')->nullable()->after('api_url');
            $table->longText('api_response')->nullable()->after('api_body');
        });
    }

    public function down(): void
    {
        Schema::table('prompt_functions', function (Blueprint $table) {
            $table->dropColumn(['api_method', 'api_url', 'api_body', 'api_response']);
        });
    }
};
