<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEmailsTable extends Migration
{
    /**
     * Run the migrations.
     * This creates the emails table in client databases
     *
     * @return void
     */
    public function up()
    {
        Schema::create('emails', function (Blueprint $table) {
            $table->id();
            $table->string('message_id', 255)->nullable();
            $table->char('message_id_hash', 64)->unique();
            $table->string('from_email', 255);
            $table->string('from_name', 255)->nullable();
            $table->text('to_email');
            $table->text('subject')->nullable();
            $table->longText('body_text')->nullable();
            $table->dateTime('received_date');
            $table->tinyInteger('has_attachments')->default(0);
            $table->timestamp('created_at')->useCurrent();

            // Indexes for performance
            $table->index('message_id_hash');
            $table->index('from_email');
            $table->index('received_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('emails');
    }
}
