<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('line_detail_ai', function (Blueprint $table) {
            $table->increments('id');
            $table->bigInteger('extension')->nullable();            
            $table->enum('route', array('IN','OUT','C2C'));
            $table->enum('type', array('manual','dialer','predictive_dial','outbound_ai','c2c'))->default('outbound_ai');
            $table->bigInteger('number');
            $table->string('channel')->nullable();
            $table->timestamp('start_time')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->integer('campaign_id')->nullable();
            $table->integer('lead_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('line_detail_ai');
    }
};
