<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cdr_ai', function (Blueprint $table) {
            $table->string('unique_id', 64)
                  ->nullable()
                  ->after('id')
                  ->index();
        });

        Schema::table('line_detail_ai', function (Blueprint $table) {
            $table->string('unique_id', 64)
                  ->nullable()
                  ->after('id')
                  ->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cdr_ai', function (Blueprint $table) {
            $table->dropIndex(['unique_id']);
            $table->dropColumn('unique_id');
        });

        Schema::table('line_detail_ai', function (Blueprint $table) {
            $table->dropIndex(['unique_id']);
            $table->dropColumn('unique_id');
        });
    }
};
