<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusColumnsToLeadReportTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('lead_report', function (Blueprint $table) {
            $table->enum('status', ['PROCESSING', 'CALLED', 'COMPLETED', 'FAILED'])
                  ->default('COMPLETED')
                  ->after('disposition_id');
            $table->timestamp('picked_at')->nullable()->after('status');
            $table->unsignedTinyInteger('attempt_count')->default(1)->after('picked_at');
            $table->index(['campaign_id', 'status'], 'idx_lead_report_campaign_status');
            $table->index(['campaign_id', 'picked_at'], 'idx_lead_report_campaign_picked');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('lead_report', function (Blueprint $table) {
            $table->dropIndex('idx_lead_report_campaign_status');
            $table->dropIndex('idx_lead_report_campaign_picked');
            $table->dropColumn(['status', 'picked_at', 'attempt_count']);
        });
    }
}
