<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPauseReasonToCampaignTable extends Migration
{
    public function up()
    {
        Schema::table('campaign', function (Blueprint $table) {
            $table->string('pause_reason', 50)->nullable()->default(null)->after('status');
            $table->index(['dial_mode', 'status', 'pause_reason'], 'idx_campaign_mode_status_pause');
        });
    }

    public function down()
    {
        Schema::table('campaign', function (Blueprint $table) {
            $table->dropIndex('idx_campaign_mode_status_pause');
            $table->dropColumn('pause_reason');
        });
    }
}
