<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('call_analysis_logs', function (Blueprint $table) {
            $table->id();
            $table->string('wav_url')->nullable();
            $table->longText('transcript')->nullable();
            $table->longText('openai_request')->nullable();
            $table->longText('openai_response')->nullable();
            $table->longText('parsed_response')->nullable();
            $table->string('status')->default('pending'); // success, failed
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('call_analysis_logs');
    }
};
