<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('client_call_rates', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->unsignedBigInteger('client_id')->index();
            $table->decimal('rate', 10, 4)->default(0.0000)->comment('Rate per minute');
            $table->string('currency_code', 10)->default('USD')->comment('Currency code like USD, INR');
            $table->timestamps();

            // Optionally ensure unique rate per client (if needed)
            $table->unique('client_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('client_call_rates');
    }
};
