<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('client_call_rates', function (Blueprint $table) {
            $table->string('product', 100)
                  ->nullable()
                  ->after('client_id')
                  ->comment('Product or service name associated with the rate');
        });
    }

    public function down()
    {
        Schema::table('client_call_rates', function (Blueprint $table) {
            $table->dropColumn('product');
        });
    }
};
