<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->boolean('auto_reload_enabled')->default(0); // adjust column placement
            $table->decimal('auto_reload_threshold', 10, 2)->nullable()->after('auto_reload_enabled');
            $table->decimal('auto_reload_amount', 10, 2)->nullable()->after('auto_reload_threshold');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'auto_reload_enabled',
                'auto_reload_threshold',
                'auto_reload_amount',
            ]);
        });
    }
};
