<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->string('razorpay_customer_id', 100)
                ->nullable()
                ->after('razorpay_auto_recharge_customer_id');

            $table->string('razorpay_token_id', 100)
                ->nullable()
                ->after('razorpay_customer_id');

            $table->string('razorpay_mandate_id', 100)
                ->nullable()
                ->after('razorpay_token_id');
        });
    }

    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn([
                'razorpay_customer_id',
                'razorpay_token_id',
                'razorpay_mandate_id',
            ]);
        });
    }
};
