<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('leadmiepro_registrations', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('email')->unique();
            $table->string('company_name');
            $table->string('phone')->nullable();
            $table->string('password');

            // Email OTP / Mobile OTP
            $table->string('email_otp')->nullable();
            $table->string('mobile_otp')->nullable();

            // Verified timestamps
            $table->timestamp('email_verified_at')->nullable();
            $table->timestamp('mobile_verified_at')->nullable();

            // Admin/User notification status
            $table->boolean('email_sent_admin')->default(false);
            $table->boolean('email_sent_user')->default(false);

            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('leadmiepro_registrations');
    }
};
