<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddAutoRechargeLockColumnsToUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::connection('master')->table('users', function (Blueprint $table) {
            // Track when the last auto-recharge was attempted
            $table->timestamp('auto_recharge_last_attempt')->nullable()->after('razorpay_mandate_id');
            // Flag to indicate if an auto-recharge is currently pending/in-progress
            $table->boolean('auto_recharge_pending')->default(0)->after('auto_recharge_last_attempt');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::connection('master')->table('users', function (Blueprint $table) {
            $table->dropColumn(['auto_recharge_last_attempt', 'auto_recharge_pending']);
        });
    }
}
