<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
      // Owner (main user) reference
      $table->unsignedBigInteger('owner_id')
            ->nullable()
            ->after('id');

      // User type: owner | subuser
      $table->string('user_type', 20)
            ->nullable()
            ->after('owner_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop FK first if enabled
            // $table->dropForeign(['owner_id']);

            $table->dropColumn(['owner_id', 'user_type']);
        });
    }
};
