<?php

use Illuminate\Database\Seeder;
use App\Model\Master\GoogleLanguage;
use Illuminate\Support\Facades\DB;

class GoogleLanguageSeeder extends Seeder {

    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run() {
        $arrLanguage = [
            ["Afrikaans (South Africa)", "Standard", "af-ZA", "af-ZA-Standard-A", "FEMALE"],
            ["Arabic", "Standard", "ar-XA", "ar-XA-Standard-A", "FEMALE"],
            ["Arabic", "Standard", "ar-XA", "ar-XA-Standard-B", "MALE"],
            ["Arabic", "Standard", "ar-XA", "ar-XA-Standard-C", "MALE"],
            ["Arabic", "Standard", "ar-XA", "ar-XA-Standard-D", "FEMALE"],
            ["Arabic", "WaveNet", "ar-XA", "ar-XA-Wavenet-A", "FEMALE"],
            ["Arabic", "WaveNet", "ar-XA", "ar-XA-Wavenet-B", "MALE"],
            ["Arabic", "WaveNet", "ar-XA", "ar-XA-Wavenet-C", "MALE"],
            ["Arabic", "WaveNet", "ar-XA", "ar-XA-Wavenet-D", "FEMALE"],
            ["Bengali (India)", "Standard", "bn-IN", "bn-IN-Standard-A", "FEMALE"],
            ["Bengali (India)", "Standard", "bn-IN", "bn-IN-Standard-B", "MALE"],
            ["Bengali (India)", "WaveNet", "bn-IN", "bn-IN-Wavenet-A", "FEMALE"],
            ["Bengali (India)", "WaveNet", "bn-IN", "bn-IN-Wavenet-B", "MALE"],
            ["Bulgarian (Bulgaria)", "Standard", "bg-BG", "bg-bg-Standard-A", "FEMALE"],
            ["Catalan (Spain)", "Standard", "ca-ES", "ca-es-Standard-A", "FEMALE"],
            ["Chinese (Hong Kong)", "Standard", "yue-HK", "yue-HK-Standard-A", "FEMALE"],
            ["Chinese (Hong Kong)", "Standard", "yue-HK", "yue-HK-Standard-B", "MALE"],
            ["Chinese (Hong Kong)", "Standard", "yue-HK", "yue-HK-Standard-C", "FEMALE"],
            ["Chinese (Hong Kong)", "Standard", "yue-HK", "yue-HK-Standard-D", "MALE"],
            ["Czech (Czech Republic)", "Standard", "cs-CZ", "cs-CZ-Standard-A", "FEMALE"],
            ["Czech (Czech Republic)", "WaveNet", "cs-CZ", "cs-CZ-Wavenet-A", "FEMALE"],
            ["Danish (Denmark)", "Standard", "da-DK", "da-DK-Standard-A", "FEMALE"],
            ["Danish (Denmark)", "Standard", "da-DK", "da-DK-Standard-C", "MALE"],
            ["Danish (Denmark)", "Standard", "da-DK", "da-DK-Standard-D", "FEMALE"],
            ["Danish (Denmark)", "Standard", "da-DK", "da-DK-Standard-E", "FEMALE"],
            ["Danish (Denmark)", "WaveNet", "da-DK", "da-DK-Wavenet-A", "FEMALE"],
            ["Danish (Denmark)", "WaveNet", "da-DK", "da-DK-Wavenet-C", "MALE"],
            ["Danish (Denmark)", "WaveNet", "da-DK", "da-DK-Wavenet-D", "FEMALE"],
            ["Danish (Denmark)", "WaveNet", "da-DK", "da-DK-Wavenet-E", "FEMALE"],
            ["Dutch (Netherlands)", "Standard", "nl-NL", "nl-NL-Standard-A", "FEMALE"],
            ["Dutch (Netherlands)", "Standard", "nl-NL", "nl-NL-Standard-B", "MALE"],
            ["Dutch (Netherlands)", "Standard", "nl-NL", "nl-NL-Standard-C", "MALE"],
            ["Dutch (Netherlands)", "Standard", "nl-NL", "nl-NL-Standard-D", "FEMALE"],
            ["Dutch (Netherlands)", "Standard", "nl-NL", "nl-NL-Standard-E", "FEMALE"],
            ["Dutch (Netherlands)", "WaveNet", "nl-NL", "nl-NL-Wavenet-A", "FEMALE"],
            ["Dutch (Netherlands)", "WaveNet", "nl-NL", "nl-NL-Wavenet-B", "MALE"],
            ["Dutch (Netherlands)", "WaveNet", "nl-NL", "nl-NL-Wavenet-C", "MALE"],
            ["Dutch (Netherlands)", "WaveNet", "nl-NL", "nl-NL-Wavenet-D", "FEMALE"],
            ["Dutch (Netherlands)", "WaveNet", "nl-NL", "nl-NL-Wavenet-E", "FEMALE"],
            ["English (Australia)", "Standard", "en-AU", "en-AU-Standard-A", "FEMALE"],
            ["English (Australia)", "Standard", "en-AU", "en-AU-Standard-B", "MALE"],
            ["English (Australia)", "Standard", "en-AU", "en-AU-Standard-C", "FEMALE"],
            ["English (Australia)", "Standard", "en-AU", "en-AU-Standard-D", "MALE"],
            ["English (Australia)", "WaveNet", "en-AU", "en-AU-Wavenet-A", "FEMALE"],
            ["English (Australia)", "WaveNet", "en-AU", "en-AU-Wavenet-B", "MALE"],
            ["English (Australia)", "WaveNet", "en-AU", "en-AU-Wavenet-C", "FEMALE"],
            ["English (Australia)", "WaveNet", "en-AU", "en-AU-Wavenet-D", "MALE"],
            ["English (India)", "Standard", "en-IN", "en-IN-Standard-A", "FEMALE"],
            ["English (India)", "Standard", "en-IN", "en-IN-Standard-B", "MALE"],
            ["English (India)", "Standard", "en-IN", "en-IN-Standard-C", "MALE"],
            ["English (India)", "Standard", "en-IN", "en-IN-Standard-D", "FEMALE"],
            ["English (India)", "WaveNet", "en-IN", "en-IN-Wavenet-A", "FEMALE"],
            ["English (India)", "WaveNet", "en-IN", "en-IN-Wavenet-B", "MALE"],
            ["English (India)", "WaveNet", "en-IN", "en-IN-Wavenet-C", "MALE"],
            ["English (India)", "WaveNet", "en-IN", "en-IN-Wavenet-D", "FEMALE"],
            ["English (UK)", "Standard", "en-GB", "en-GB-Standard-A", "FEMALE"],
            ["English (UK)", "Standard", "en-GB", "en-GB-Standard-B", "MALE"],
            ["English (UK)", "Standard", "en-GB", "en-GB-Standard-C", "FEMALE"],
            ["English (UK)", "Standard", "en-GB", "en-GB-Standard-D", "MALE"],
            ["English (UK)", "Standard", "en-GB", "en-GB-Standard-F", "FEMALE"],
            ["English (UK)", "WaveNet", "en-GB", "en-GB-Wavenet-A", "FEMALE"],
            ["English (UK)", "WaveNet", "en-GB", "en-GB-Wavenet-B", "MALE"],
            ["English (UK)", "WaveNet", "en-GB", "en-GB-Wavenet-C", "FEMALE"],
            ["English (UK)", "WaveNet", "en-GB", "en-GB-Wavenet-D", "MALE"],
            ["English (UK)", "WaveNet", "en-GB", "en-GB-Wavenet-F", "FEMALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-A", "MALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-B", "MALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-C", "FEMALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-D", "MALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-E", "FEMALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-F", "FEMALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-G", "FEMALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-H", "FEMALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-I", "MALE"],
            ["English (US)", "Standard", "en-US", "en-US-Standard-J", "MALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-A", "MALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-B", "MALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-C", "FEMALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-D", "MALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-E", "FEMALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-F", "FEMALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-G", "FEMALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-H", "FEMALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-I", "MALE"],
            ["English (US)", "WaveNet", "en-US", "en-US-Wavenet-J", "MALE"],
            ["Filipino (Philippines)", "Standard", "fil-PH", "fil-PH-Standard-A", "FEMALE"],
            ["Filipino (Philippines)", "Standard", "fil-PH", "fil-PH-Standard-B", "FEMALE"],
            ["Filipino (Philippines)", "Standard", "fil-PH", "fil-PH-Standard-C", "MALE"],
            ["Filipino (Philippines)", "Standard", "fil-PH", "fil-PH-Standard-D", "MALE"],
            ["Filipino (Philippines)", "WaveNet", "fil-PH", "fil-PH-Wavenet-A", "FEMALE"],
            ["Filipino (Philippines)", "WaveNet", "fil-PH", "fil-PH-Wavenet-B", "FEMALE"],
            ["Filipino (Philippines)", "WaveNet", "fil-PH", "fil-PH-Wavenet-C", "MALE"],
            ["Filipino (Philippines)", "WaveNet", "fil-PH", "fil-PH-Wavenet-D", "MALE"],
            ["Finnish (Finland)", "Standard", "fi-FI", "fi-FI-Standard-A", "FEMALE"],
            ["Finnish (Finland)", "WaveNet", "fi-FI", "fi-FI-Wavenet-A", "FEMALE"],
            ["French (Canada)", "Standard", "fr-CA", "fr-CA-Standard-A", "FEMALE"],
            ["French (Canada)", "Standard", "fr-CA", "fr-CA-Standard-B", "MALE"],
            ["French (Canada)", "Standard", "fr-CA", "fr-CA-Standard-C", "FEMALE"],
            ["French (Canada)", "Standard", "fr-CA", "fr-CA-Standard-D", "MALE"],
            ["French (Canada)", "WaveNet", "fr-CA", "fr-CA-Wavenet-A", "FEMALE"],
            ["French (Canada)", "WaveNet", "fr-CA", "fr-CA-Wavenet-B", "MALE"],
            ["French (Canada)", "WaveNet", "fr-CA", "fr-CA-Wavenet-C", "FEMALE"],
            ["French (Canada)", "WaveNet", "fr-CA", "fr-CA-Wavenet-D", "MALE"],
            ["French (France)", "Standard", "fr-FR", "fr-FR-Standard-A", "FEMALE"],
            ["French (France)", "Standard", "fr-FR", "fr-FR-Standard-B", "MALE"],
            ["French (France)", "Standard", "fr-FR", "fr-FR-Standard-C", "FEMALE"],
            ["French (France)", "Standard", "fr-FR", "fr-FR-Standard-D", "MALE"],
            ["French (France)", "Standard", "fr-FR", "fr-FR-Standard-E", "FEMALE"],
            ["French (France)", "WaveNet", "fr-FR", "fr-FR-Wavenet-A", "FEMALE"],
            ["French (France)", "WaveNet", "fr-FR", "fr-FR-Wavenet-B", "MALE"],
            ["French (France)", "WaveNet", "fr-FR", "fr-FR-Wavenet-C", "FEMALE"],
            ["French (France)", "WaveNet", "fr-FR", "fr-FR-Wavenet-D", "MALE"],
            ["French (France)", "WaveNet", "fr-FR", "fr-FR-Wavenet-E", "FEMALE"],
            ["German (Germany)", "Standard", "de-DE", "de-DE-Standard-A", "FEMALE"],
            ["German (Germany)", "Standard", "de-DE", "de-DE-Standard-B", "MALE"],
            ["German (Germany)", "Standard", "de-DE", "de-DE-Standard-C", "FEMALE"],
            ["German (Germany)", "Standard", "de-DE", "de-DE-Standard-D", "MALE"],
            ["German (Germany)", "Standard", "de-DE", "de-DE-Standard-E", "MALE"],
            ["German (Germany)", "Standard", "de-DE", "de-DE-Standard-F", "FEMALE"],
            ["German (Germany)", "WaveNet", "de-DE", "de-DE-Wavenet-A", "FEMALE"],
            ["German (Germany)", "WaveNet", "de-DE", "de-DE-Wavenet-B", "MALE"],
            ["German (Germany)", "WaveNet", "de-DE", "de-DE-Wavenet-C", "FEMALE"],
            ["German (Germany)", "WaveNet", "de-DE", "de-DE-Wavenet-D", "MALE"],
            ["German (Germany)", "WaveNet", "de-DE", "de-DE-Wavenet-E", "MALE"],
            ["German (Germany)", "WaveNet", "de-DE", "de-DE-Wavenet-F", "FEMALE"],
            ["Greek (Greece)", "Standard", "el-GR", "el-GR-Standard-A", "FEMALE"],
            ["Greek (Greece)", "WaveNet", "el-GR", "el-GR-Wavenet-A", "FEMALE"],
            ["Gujarati (India)", "Standard", "gu-IN", "gu-IN-Standard-A", "FEMALE"],
            ["Gujarati (India)", "Standard", "gu-IN", "gu-IN-Standard-B", "MALE"],
            ["Gujarati (India)", "WaveNet", "gu-IN", "gu-IN-Wavenet-A", "FEMALE"],
            ["Gujarati (India)", "WaveNet", "gu-IN", "gu-IN-Wavenet-B", "MALE"],
            ["Hindi (India)", "Standard", "hi-IN", "hi-IN-Standard-A", "FEMALE"],
            ["Hindi (India)", "Standard", "hi-IN", "hi-IN-Standard-B", "MALE"],
            ["Hindi (India)", "Standard", "hi-IN", "hi-IN-Standard-C", "MALE"],
            ["Hindi (India)", "Standard", "hi-IN", "hi-IN-Standard-D", "FEMALE"],
            ["Hindi (India)", "WaveNet", "hi-IN", "hi-IN-Wavenet-A", "FEMALE"],
            ["Hindi (India)", "WaveNet", "hi-IN", "hi-IN-Wavenet-B", "MALE"],
            ["Hindi (India)", "WaveNet", "hi-IN", "hi-IN-Wavenet-C", "MALE"],
            ["Hindi (India)", "WaveNet", "hi-IN", "hi-IN-Wavenet-D", "FEMALE"],
            ["Hungarian (Hungary)", "Standard", "hu-HU", "hu-HU-Standard-A", "FEMALE"],
            ["Hungarian (Hungary)", "WaveNet", "hu-HU", "hu-HU-Wavenet-A", "FEMALE"],
            ["Icelandic (Iceland)", "Standard", "is-IS", "is-is-Standard-A", "FEMALE"],
            ["Indonesian (Indonesia)", "Standard", "id-ID", "id-ID-Standard-A", "FEMALE"],
            ["Indonesian (Indonesia)", "Standard", "id-ID", "id-ID-Standard-B", "MALE"],
            ["Indonesian (Indonesia)", "Standard", "id-ID", "id-ID-Standard-C", "MALE"],
            ["Indonesian (Indonesia)", "Standard", "id-ID", "id-ID-Standard-D", "FEMALE"],
            ["Indonesian (Indonesia)", "WaveNet", "id-ID", "id-ID-Wavenet-A", "FEMALE"],
            ["Indonesian (Indonesia)", "WaveNet", "id-ID", "id-ID-Wavenet-B", "MALE"],
            ["Indonesian (Indonesia)", "WaveNet", "id-ID", "id-ID-Wavenet-C", "MALE"],
            ["Indonesian (Indonesia)", "WaveNet", "id-ID", "id-ID-Wavenet-D", "FEMALE"],
            ["Italian (Italy)", "Standard", "it-IT", "it-IT-Standard-A", "FEMALE"],
            ["Italian (Italy)", "Standard", "it-IT", "it-IT-Standard-B", "FEMALE"],
            ["Italian (Italy)", "Standard", "it-IT", "it-IT-Standard-C", "MALE"],
            ["Italian (Italy)", "Standard", "it-IT", "it-IT-Standard-D", "MALE"],
            ["Italian (Italy)", "WaveNet", "it-IT", "it-IT-Wavenet-A", "FEMALE"],
            ["Italian (Italy)", "WaveNet", "it-IT", "it-IT-Wavenet-B", "FEMALE"],
            ["Italian (Italy)", "WaveNet", "it-IT", "it-IT-Wavenet-C", "MALE"],
            ["Italian (Italy)", "WaveNet", "it-IT", "it-IT-Wavenet-D", "MALE"],
            ["Japanese (Japan)", "Standard", "ja-JP", "ja-JP-Standard-A", "FEMALE"],
            ["Japanese (Japan)", "Standard", "ja-JP", "ja-JP-Standard-B", "FEMALE"],
            ["Japanese (Japan)", "Standard", "ja-JP", "ja-JP-Standard-C", "MALE"],
            ["Japanese (Japan)", "Standard", "ja-JP", "ja-JP-Standard-D", "MALE"],
            ["Japanese (Japan)", "WaveNet", "ja-JP", "ja-JP-Wavenet-A", "FEMALE"],
            ["Japanese (Japan)", "WaveNet", "ja-JP", "ja-JP-Wavenet-B", "FEMALE"],
            ["Japanese (Japan)", "WaveNet", "ja-JP", "ja-JP-Wavenet-C", "MALE"],
            ["Japanese (Japan)", "WaveNet", "ja-JP", "ja-JP-Wavenet-D", "MALE"],
            ["Kannada (India)", "Standard", "kn-IN", "kn-IN-Standard-A", "FEMALE"],
            ["Kannada (India)", "Standard", "kn-IN", "kn-IN-Standard-B", "MALE"],
            ["Kannada (India)", "WaveNet", "kn-IN", "kn-IN-Wavenet-A", "FEMALE"],
            ["Kannada (India)", "WaveNet", "kn-IN", "kn-IN-Wavenet-B", "MALE"],
            ["Korean (South Korea)", "Standard", "ko-KR", "ko-KR-Standard-A", "FEMALE"],
            ["Korean (South Korea)", "Standard", "ko-KR", "ko-KR-Standard-B", "FEMALE"],
            ["Korean (South Korea)", "Standard", "ko-KR", "ko-KR-Standard-C", "MALE"],
            ["Korean (South Korea)", "Standard", "ko-KR", "ko-KR-Standard-D", "MALE"],
            ["Korean (South Korea)", "WaveNet", "ko-KR", "ko-KR-Wavenet-A", "FEMALE"],
            ["Korean (South Korea)", "WaveNet", "ko-KR", "ko-KR-Wavenet-B", "FEMALE"],
            ["Korean (South Korea)", "WaveNet", "ko-KR", "ko-KR-Wavenet-C", "MALE"],
            ["Korean (South Korea)", "WaveNet", "ko-KR", "ko-KR-Wavenet-D", "MALE"],
            ["Latvian (Latvia)", "Standard", "lv-LV", "lv-lv-Standard-A", "MALE"],
            ["Malayalam (India)", "Standard", "ml-IN", "ml-IN-Standard-A", "FEMALE"],
            ["Malayalam (India)", "Standard", "ml-IN", "ml-IN-Standard-B", "MALE"],
            ["Malayalam (India)", "WaveNet", "ml-IN", "ml-IN-Wavenet-A", "FEMALE"],
            ["Malayalam (India)", "WaveNet", "ml-IN", "ml-IN-Wavenet-B", "MALE"],
            ["Mandarin Chinese", "Standard", "cmn-CN", "cmn-CN-Standard-A", "FEMALE"],
            ["Mandarin Chinese", "Standard", "cmn-CN", "cmn-CN-Standard-B", "MALE"],
            ["Mandarin Chinese", "Standard", "cmn-CN", "cmn-CN-Standard-C", "MALE"],
            ["Mandarin Chinese", "Standard", "cmn-CN", "cmn-CN-Standard-D", "FEMALE"],
            ["Mandarin Chinese", "WaveNet", "cmn-CN", "cmn-CN-Wavenet-A", "FEMALE"],
            ["Mandarin Chinese", "WaveNet", "cmn-CN", "cmn-CN-Wavenet-B", "MALE"],
            ["Mandarin Chinese", "WaveNet", "cmn-CN", "cmn-CN-Wavenet-C", "MALE"],
            ["Mandarin Chinese", "WaveNet", "cmn-CN", "cmn-CN-Wavenet-D", "FEMALE"],
            ["Mandarin Chinese", "Standard", "cmn-TW", "cmn-TW-Standard-A", "FEMALE"],
            ["Mandarin Chinese", "Standard", "cmn-TW", "cmn-TW-Standard-B", "MALE"],
            ["Mandarin Chinese", "Standard", "cmn-TW", "cmn-TW-Standard-C", "MALE"],
            ["Mandarin Chinese", "WaveNet", "cmn-TW", "cmn-TW-Wavenet-A", "FEMALE"],
            ["Mandarin Chinese", "WaveNet", "cmn-TW", "cmn-TW-Wavenet-B", "MALE"],
            ["Mandarin Chinese", "WaveNet", "cmn-TW", "cmn-TW-Wavenet-C", "MALE"],
            ["Norwegian (Norway)", "Standard", "nb-NO", "nb-NO-Standard-A", "FEMALE"],
            ["Norwegian (Norway)", "Standard", "nb-NO", "nb-NO-Standard-B", "MALE"],
            ["Norwegian (Norway)", "Standard", "nb-NO", "nb-NO-Standard-C", "FEMALE"],
            ["Norwegian (Norway)", "Standard", "nb-NO", "nb-NO-Standard-D", "MALE"],
            ["Norwegian (Norway)", "WaveNet", "nb-NO", "nb-NO-Wavenet-A", "FEMALE"],
            ["Norwegian (Norway)", "WaveNet", "nb-NO", "nb-NO-Wavenet-B", "MALE"],
            ["Norwegian (Norway)", "WaveNet", "nb-NO", "nb-NO-Wavenet-C", "FEMALE"],
            ["Norwegian (Norway)", "WaveNet", "nb-NO", "nb-NO-Wavenet-D", "MALE"],
            ["Norwegian (Norway)", "Standard", "nb-NO", "nb-no-Standard-E", "FEMALE"],
            ["Norwegian (Norway)", "Standard", "nb-NO", "nb-no-Standard-E", "FEMALE"],
            ["Norwegian (Norway)", "WaveNet", "nb-NO", "nb-no-Wavenet-E", "FEMALE"],
            ["Polish (Poland)", "Standard", "pl-PL", "pl-PL-Standard-A", "FEMALE"],
            ["Polish (Poland)", "Standard", "pl-PL", "pl-PL-Standard-B", "MALE"],
            ["Polish (Poland)", "Standard", "pl-PL", "pl-PL-Standard-C", "MALE"],
            ["Polish (Poland)", "Standard", "pl-PL", "pl-PL-Standard-D", "FEMALE"],
            ["Polish (Poland)", "Standard", "pl-PL", "pl-PL-Standard-E", "FEMALE"],
            ["Polish (Poland)", "WaveNet", "pl-PL", "pl-PL-Wavenet-A", "FEMALE"],
            ["Polish (Poland)", "WaveNet", "pl-PL", "pl-PL-Wavenet-B", "MALE"],
            ["Polish (Poland)", "WaveNet", "pl-PL", "pl-PL-Wavenet-C", "MALE"],
            ["Polish (Poland)", "WaveNet", "pl-PL", "pl-PL-Wavenet-D", "FEMALE"],
            ["Polish (Poland)", "WaveNet", "pl-PL", "pl-PL-Wavenet-E", "FEMALE"],
            ["Portuguese (Brazil)", "Standard", "pt-BR", "pt-BR-Standard-A", "FEMALE"],
            ["Portuguese (Brazil)", "WaveNet", "pt-BR", "pt-BR-Wavenet-A", "FEMALE"],
            ["Portuguese (Portugal)", "Standard", "pt-PT", "pt-PT-Standard-A", "FEMALE"],
            ["Portuguese (Portugal)", "Standard", "pt-PT", "pt-PT-Standard-B", "MALE"],
            ["Portuguese (Portugal)", "Standard", "pt-PT", "pt-PT-Standard-C", "MALE"],
            ["Portuguese (Portugal)", "Standard", "pt-PT", "pt-PT-Standard-D", "FEMALE"],
            ["Portuguese (Portugal)", "WaveNet", "pt-PT", "pt-PT-Wavenet-A", "FEMALE"],
            ["Portuguese (Portugal)", "WaveNet", "pt-PT", "pt-PT-Wavenet-B", "MALE"],
            ["Portuguese (Portugal)", "WaveNet", "pt-PT", "pt-PT-Wavenet-C", "MALE"],
            ["Portuguese (Portugal)", "WaveNet", "pt-PT", "pt-PT-Wavenet-D", "FEMALE"],
            ["Romanian (Romania)", "Standard", "ro-RO", "ro-RO-Standard-A", "FEMALE"],
            ["Romanian (Romania)", "WaveNet", "ro-RO", "ro-RO-Wavenet-A", "FEMALE"],
            ["Russian (Russia)", "Standard", "ru-RU", "ru-RU-Standard-A", "FEMALE"],
            ["Russian (Russia)", "Standard", "ru-RU", "ru-RU-Standard-B", "MALE"],
            ["Russian (Russia)", "Standard", "ru-RU", "ru-RU-Standard-C", "FEMALE"],
            ["Russian (Russia)", "Standard", "ru-RU", "ru-RU-Standard-D", "MALE"],
            ["Russian (Russia)", "Standard", "ru-RU", "ru-RU-Standard-E", "FEMALE"],
            ["Russian (Russia)", "WaveNet", "ru-RU", "ru-RU-Wavenet-A", "FEMALE"],
            ["Russian (Russia)", "WaveNet", "ru-RU", "ru-RU-Wavenet-B", "MALE"],
            ["Russian (Russia)", "WaveNet", "ru-RU", "ru-RU-Wavenet-C", "FEMALE"],
            ["Russian (Russia)", "WaveNet", "ru-RU", "ru-RU-Wavenet-D", "MALE"],
            ["Russian (Russia)", "WaveNet", "ru-RU", "ru-RU-Wavenet-E", "FEMALE"],
            ["Serbian (Cyrillic)", "Standard", "sr-RS", "sr-rs-Standard-A", "FEMALE"],
            ["Slovak (Slovakia)", "Standard", "sk-SK", "sk-SK-Standard-A", "FEMALE"],
            ["Slovak (Slovakia)", "WaveNet", "sk-SK", "sk-SK-Wavenet-A", "FEMALE"],
            ["Spanish (Spain)", "Standard", "es-ES", "es-ES-Standard-A", "FEMALE"],
            ["Spanish (Spain)", "Standard", "es-ES", "es-ES-Standard-B", "MALE"],
            ["Spanish (Spain)", "Standard", "es-ES", "es-ES-Standard-C", "FEMALE"],
            ["Spanish (Spain)", "Standard", "es-ES", "es-ES-Standard-D", "FEMALE"],
            ["Spanish (Spain)", "WaveNet", "es-ES", "es-ES-Wavenet-B", "MALE"],
            ["Spanish (Spain)", "WaveNet", "es-ES", "es-ES-Wavenet-C", "FEMALE"],
            ["Spanish (Spain)", "WaveNet", "es-ES", "es-ES-Wavenet-D", "FEMALE"],
            ["Spanish (US)", "Standard", "es-US", "es-US-Standard-A", "FEMALE"],
            ["Spanish (US)", "Standard", "es-US", "es-US-Standard-B", "MALE"],
            ["Spanish (US)", "Standard", "es-US", "es-US-Standard-C", "MALE"],
            ["Spanish (US)", "WaveNet", "es-US", "es-US-Wavenet-A", "FEMALE"],
            ["Spanish (US)", "WaveNet", "es-US", "es-US-Wavenet-B", "MALE"],
            ["Spanish (US)", "WaveNet", "es-US", "es-US-Wavenet-C", "MALE"],
            ["Swedish (Sweden)", "Standard", "sv-SE", "sv-SE-Standard-A", "FEMALE"],
            ["Swedish (Sweden)", "WaveNet", "sv-SE", "sv-SE-Wavenet-A", "FEMALE"],
            ["Tamil (India)", "Standard", "ta-IN", "ta-IN-Standard-A", "FEMALE"],
            ["Tamil (India)", "Standard", "ta-IN", "ta-IN-Standard-B", "MALE"],
            ["Tamil (India)", "WaveNet", "ta-IN", "ta-IN-Wavenet-A", "FEMALE"],
            ["Tamil (India)", "WaveNet", "ta-IN", "ta-IN-Wavenet-B", "MALE"],
            ["Telugu (India)", "Standard", "te-IN", "te-IN-Standard-A", "FEMALE"],
            ["Telugu (India)", "Standard", "te-IN", "te-IN-Standard-B", "MALE"],
            ["Thai (Thailand)", "Standard", "th-TH", "th-TH-Standard-A", "FEMALE"],
            ["Turkish (Turkey)", "Standard", "tr-TR", "tr-TR-Standard-A", "FEMALE"],
            ["Turkish (Turkey)", "Standard", "tr-TR", "tr-TR-Standard-B", "MALE"],
            ["Turkish (Turkey)", "Standard", "tr-TR", "tr-TR-Standard-C", "FEMALE"],
            ["Turkish (Turkey)", "Standard", "tr-TR", "tr-TR-Standard-D", "FEMALE"],
            ["Turkish (Turkey)", "Standard", "tr-TR", "tr-TR-Standard-E", "MALE"],
            ["Turkish (Turkey)", "WaveNet", "tr-TR", "tr-TR-Wavenet-A", "FEMALE"],
            ["Turkish (Turkey)", "WaveNet", "tr-TR", "tr-TR-Wavenet-B", "MALE"],
            ["Turkish (Turkey)", "WaveNet", "tr-TR", "tr-TR-Wavenet-C", "FEMALE"],
            ["Turkish (Turkey)", "WaveNet", "tr-TR", "tr-TR-Wavenet-D", "FEMALE"],
            ["Turkish (Turkey)", "WaveNet", "tr-TR", "tr-TR-Wavenet-E", "MALE"],
            ["Ukrainian (Ukraine)", "Standard", "uk-UA", "uk-UA-Standard-A", "FEMALE"],
            ["Ukrainian (Ukraine)", "WaveNet", "uk-UA", "uk-UA-Wavenet-A", "FEMALE"],
            ["Vietnamese (Vietnam)", "Standard", "vi-VN", "vi-VN-Standard-A", "FEMALE"],
            ["Vietnamese (Vietnam)", "Standard", "vi-VN", "vi-VN-Standard-B", "MALE"],
            ["Vietnamese (Vietnam)", "Standard", "vi-VN", "vi-VN-Standard-C", "FEMALE"],
            ["Vietnamese (Vietnam)", "Standard", "vi-VN", "vi-VN-Standard-D", "MALE"],
            ["Vietnamese (Vietnam)", "WaveNet", "vi-VN", "vi-VN-Wavenet-A", "FEMALE"],
            ["Vietnamese (Vietnam)", "WaveNet", "vi-VN", "vi-VN-Wavenet-B", "MALE"],
            ["Vietnamese (Vietnam)", "WaveNet", "vi-VN", "vi-VN-Wavenet-C", "FEMALE"],
            ["Vietnamese (Vietnam)", "WaveNet", "vi-VN", "vi-VN-Wavenet-D", "MALE"]
        ];

        if(GoogleLanguage::all()->count() > 1){
            GoogleLanguage::truncate();
        }

        foreach ($arrLanguage as $language) {
            $data['language'] = $language[0];
            $data['voice_type'] = $language[1];
            $data['language_code'] = $language[2];
            $data['voice_name'] = $language[3];
            $data['ssml_gender'] = $language[4];
            $query = "INSERT INTO google_language (language, voice_type, language_code, voice_name, ssml_gender) "
                . " VALUE (:language, :voice_type, :language_code, :voice_name, :ssml_gender)";
            DB::connection('master')->insert($query, $data);
        }
    }

}
