<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Email Verification Code</title>
</head>
<body style="font-family: Arial, sans-serif; background: #f9f9f9; padding: 20px;">
    <table width="100%" cellpadding="0" cellspacing="0" style="
        max-width: 600px;
        margin: auto;
        background: #ffffff;
        border-radius: 8px;
        padding: 20px;
        box-shadow: 0 2px 5px rgba(0,0,0,0.1);
    ">
        <tr>
            <td>
                <div class="logo" style="text-align:center; margin-bottom:18px;">
                    <img src="<?php echo e(env('LEADMINE_LOGO', 'https://leadmine.pro/web/assets/images/headlogo.webp')); ?>" alt="Logo" style="max-width: 180px;">
                </div>
                <h2 style="color: #333;">Verify Your Email Address</h2>

                <p style="color: #555;">
                    Hello <?php echo e($name ?? 'User'); ?>,
                </p>

                <p style="color: #555;">
                    Thank you for registering with us.<br>
                    Please use the following OTP to verify your email address:
                </p>

                <div style="margin: 30px 0; text-align: center;">
                    <span style="display: inline-block; background: #f2f2f2; color: #222; font-size: 28px; letter-spacing: 6px; padding: 16px 32px; border-radius: 6px; font-weight: bold;">
                        <?php echo e($otp ?? '------'); ?>

                    </span>
                </div>

                <p style="color: #555;">
                    This OTP is valid for a limited time. Please do not share it with anyone.
                </p>

                <p style="margin-top: 20px; color: #888; font-size: 12px;">
                    If you did not request this, please ignore this email.
                </p>
            </td>
        </tr>
    </table>
</body>
</html>
<?php /**PATH /var/www/html/leadmine/backend/resources/views/emails/leadmine-pro/email-otp.blade.php ENDPATH**/ ?>