<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\AlertCenter;

class BatchUndeleteAlertsRequest extends \Google\Collection
{
  protected $collection_key = 'alertId';
  /**
   * Required. The list of alert IDs to undelete.
   *
   * @var string[]
   */
  public $alertId;
  /**
   * Optional. The unique identifier of the Google Workspace account of the
   * customer the alerts are associated with. The `customer_id` must have the
   * initial "C" stripped (for example, `046psxkn`). Inferred from the caller
   * identity if not provided. [Find your customer
   * ID](https://support.google.com/cloudidentity/answer/10070793).
   *
   * @var string
   */
  public $customerId;

  /**
   * Required. The list of alert IDs to undelete.
   *
   * @param string[] $alertId
   */
  public function setAlertId($alertId)
  {
    $this->alertId = $alertId;
  }
  /**
   * @return string[]
   */
  public function getAlertId()
  {
    return $this->alertId;
  }
  /**
   * Optional. The unique identifier of the Google Workspace account of the
   * customer the alerts are associated with. The `customer_id` must have the
   * initial "C" stripped (for example, `046psxkn`). Inferred from the caller
   * identity if not provided. [Find your customer
   * ID](https://support.google.com/cloudidentity/answer/10070793).
   *
   * @param string $customerId
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
  }
  /**
   * @return string
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(BatchUndeleteAlertsRequest::class, 'Google_Service_AlertCenter_BatchUndeleteAlertsRequest');
