<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ContainerAnalysis;

class GoogleDevtoolsContaineranalysisV1alpha1OperationMetadata extends \Google\Model
{
  /**
   * Output only. The time this operation was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Output only. The time that this operation was marked completed or failed.
   *
   * @var string
   */
  public $endTime;

  /**
   * Output only. The time this operation was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Output only. The time that this operation was marked completed or failed.
   *
   * @param string $endTime
   */
  public function setEndTime($endTime)
  {
    $this->endTime = $endTime;
  }
  /**
   * @return string
   */
  public function getEndTime()
  {
    return $this->endTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleDevtoolsContaineranalysisV1alpha1OperationMetadata::class, 'Google_Service_ContainerAnalysis_GoogleDevtoolsContaineranalysisV1alpha1OperationMetadata');
