<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DeploymentManager;

class ResourcesListResponse extends \Google\Collection
{
  protected $collection_key = 'resources';
  /**
   * A token used to continue a truncated list request.
   *
   * @var string
   */
  public $nextPageToken;
  protected $resourcesType = DeploymentmanagerResource::class;
  protected $resourcesDataType = 'array';

  /**
   * A token used to continue a truncated list request.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * Resources contained in this list response.
   *
   * @param DeploymentmanagerResource[] $resources
   */
  public function setResources($resources)
  {
    $this->resources = $resources;
  }
  /**
   * @return DeploymentmanagerResource[]
   */
  public function getResources()
  {
    return $this->resources;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ResourcesListResponse::class, 'Google_Service_DeploymentManager_ResourcesListResponse');
