<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Document;

class GoogleCloudDocumentaiV1DocumentRevisionHumanReview extends \Google\Model
{
  /**
   * Human review state. e.g. `requested`, `succeeded`, `rejected`.
   *
   * @var string
   */
  public $state;
  /**
   * A message providing more details about the current state of processing. For
   * example, the rejection reason when the state is `rejected`.
   *
   * @var string
   */
  public $stateMessage;

  /**
   * Human review state. e.g. `requested`, `succeeded`, `rejected`.
   *
   * @param string $state
   */
  public function setState($state)
  {
    $this->state = $state;
  }
  /**
   * @return string
   */
  public function getState()
  {
    return $this->state;
  }
  /**
   * A message providing more details about the current state of processing. For
   * example, the rejection reason when the state is `rejected`.
   *
   * @param string $stateMessage
   */
  public function setStateMessage($stateMessage)
  {
    $this->stateMessage = $stateMessage;
  }
  /**
   * @return string
   */
  public function getStateMessage()
  {
    return $this->stateMessage;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDocumentaiV1DocumentRevisionHumanReview::class, 'Google_Service_Document_GoogleCloudDocumentaiV1DocumentRevisionHumanReview');
