<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ThreatIntelligenceService;

class InbandVulnerabilityFindingDetail extends \Google\Model
{
  /**
   * Optional. A short description of the proof of the vulnerability.
   *
   * @var string
   */
  public $formattedProofDetails;
  /**
   * Optional. The URI that lead to this detection, if appropriate.
   *
   * @var string
   */
  public $requestUri;
  protected $vulnerabilityType = InbandVulnerability::class;
  protected $vulnerabilityDataType = '';

  /**
   * Optional. A short description of the proof of the vulnerability.
   *
   * @param string $formattedProofDetails
   */
  public function setFormattedProofDetails($formattedProofDetails)
  {
    $this->formattedProofDetails = $formattedProofDetails;
  }
  /**
   * @return string
   */
  public function getFormattedProofDetails()
  {
    return $this->formattedProofDetails;
  }
  /**
   * Optional. The URI that lead to this detection, if appropriate.
   *
   * @param string $requestUri
   */
  public function setRequestUri($requestUri)
  {
    $this->requestUri = $requestUri;
  }
  /**
   * @return string
   */
  public function getRequestUri()
  {
    return $this->requestUri;
  }
  /**
   * Required. Vulnerability metadata.
   *
   * @param InbandVulnerability $vulnerability
   */
  public function setVulnerability(InbandVulnerability $vulnerability)
  {
    $this->vulnerability = $vulnerability;
  }
  /**
   * @return InbandVulnerability
   */
  public function getVulnerability()
  {
    return $this->vulnerability;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InbandVulnerabilityFindingDetail::class, 'Google_Service_ThreatIntelligenceService_InbandVulnerabilityFindingDetail');
