<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class EligibleLendersExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $lenders;
    public function __construct($lenders)
    {
        $this->lenders = $lenders;
    }

    public function collection()
    {
        // Ensure the lenders data is an array of arrays, where each array is a row of data.
        return collect($this->lenders)->map(function($lender) {
            $maxPosition = is_string($lender->max_position) ? json_decode($lender->max_position, true) : $lender->max_position;

            // Ensure it's an array and has values
            if (is_array($maxPosition) && !empty($maxPosition)) {
                // Get the minimum and maximum values from the array
                $min = min($maxPosition);
                $max = max($maxPosition);
    
                // If min and max are the same, just show the single value; otherwise, show "min to max"
                $range = ($min == $max) ? $min : "$min to $max";
            } else {
                $range = ''; // Fallback in case no valid values
            }
            // Check if the data is a JSON string and decode it
            $industry = is_string($lender->industry) ? json_decode($lender->industry, true) : $lender->industry;
            $construction = is_array($industry) && in_array('construction', $industry) ? 'Yes' : '';
            $trucking = is_array($industry) && in_array('trucking', $industry) ? 'Yes' : '';
    // Join industry values with '/'
    $industryString = is_array($industry) ? implode('/', $industry) : '';
             // Array to map state codes to state names
    $state_names = [
        'AL' => 'Alabama',
        'AK' => 'Alaska',
        'AS' => 'American Samoa',
        'AZ' => 'Arizona',
        'AR' => 'Arkansas',
        'AE-A' => 'Armed Forces Africa',
        'AA' => 'Armed Forces Americas',
        'AE-C' => 'Armed Forces Canada',
        'AE-E' => 'Armed Forces Europe',
        'AE-M' => 'Armed Forces Middle East',
        'AP' => 'Armed Forces Pacific',
        'CA' => 'California',
        'CO' => 'Colorado',
        'CT' => 'Connecticut',
        'DE' => 'Delaware',
        'DC' => 'District of Columbia',
        'FM' => 'Federated States of Micronesia',
        'FL' => 'Florida',
        'GA' => 'Georgia',
        'GU' => 'Guam',
        'HI' => 'Hawaii',
        'ID' => 'Idaho',
        'IL' => 'Illinois',
        'IN' => 'Indiana',
        'IA' => 'Iowa',
        'KS' => 'Kansas',
        'KY' => 'Kentucky',
        'LA' => 'Louisiana',
        'ME' => 'Maine',
        'MD' => 'Maryland',
        'MA' => 'Massachusetts',
        'MI' => 'Michigan',
        'MN' => 'Minnesota',
        'MS' => 'Mississippi',
        'MO' => 'Missouri',
        'MT' => 'Montana',
        'NE' => 'Nebraska',
        'NV' => 'Nevada',
        'NH' => 'New Hampshire',
        'NJ' => 'New Jersey',
        'NM' => 'New Mexico',
        'NY' => 'New York',
        'NC' => 'North Carolina',
        'ND' => 'North Dakota',
        'MP' => 'Northern Mariana Islands',
        'OH' => 'Ohio',
        'OK' => 'Oklahoma',
        'OR' => 'Oregon',
        'PA' => 'Pennsylvania',
        'PR' => 'Puerto Rico',
        'MH' => 'Republic of Marshall Islands',
        'RI' => 'Rhode Island',
        'SC' => 'South Carolina',
        'SD' => 'South Dakota',
        'TN' => 'Tennessee',
        'TX' => 'Texas',
        'UT' => 'Utah',
        'VT' => 'Vermont',
        'VI' => 'Virgin Islands of the U.S.',
        'VA' => 'Virginia',
        'WA' => 'Washington',
        'WV' => 'West Virginia',
        'WI' => 'Wisconsin',
        'WY' => 'Wyoming',
    ];

    // Check if the data is a JSON string and decode it
    $guideline_state = is_string($lender->guideline_state) ? json_decode($lender->guideline_state, true) : $lender->guideline_state;
    $stateCA = is_array($guideline_state) && in_array('CA', $guideline_state) ? 'Yes' : '';
    // Map the state codes to their names
    $state_names_list = is_array($guideline_state) 
        ? implode('/', array_map(function($state_code) use ($state_names) {
            return $state_names[$state_code] ?? $state_code;
        }, $guideline_state))
        : $state_names[$lender->guideline_state] ?? $lender->guideline_state;
            return [
                $lender->lender_name,
                $lender->email,
                $lender->secondary_email,
                $lender->max_term,
                $range,
                $lender->min_credit_score,
                $lender->min_monthly_deposit,
                $lender->daily_balance,
                $lender->min_avg_revenue,
                $lender->min_deposits,
                $lender->min_amount,
                $lender->max_advance,
                $lender->max_negative_days,
                $lender->nsfs,
                $lender->daily,
                $lender->min_time_business,
                $lender->reverse_consolidation,
                $lender->consolidation,
                $lender->loc,
                $lender->max_mca_payoff_amount,
                $lender->ownership_percentage,
                $stateCA,
                $construction,
                $trucking,
                $lender->factor_rate,
                $state_names_list,
                $industryString,
                $lender->prohibited_industry,
                $lender->notes,

            ];
        });
    }

    public function headings(): array
    {
        return [
           'Name',
'Email',
'CC',
'Max Term',
'Position',
'FICO',
'Min Monthly Deposit',
'Average Daily Balance',
'Min Average Revenue',
'Min No of Deposits',
'Min Loan Amount',
'Max Loan Amount',
'Max Negative Days',
'NSFs',
'Daily/Weekly',
'Time In Business',
'Reverse Consolidation',
'Consolidation',
'LOC',
'Max MCA Payoff Amount',
'Ownership Percentage',
'CA',
'Construction',
'Trucking',
'Factor Rates',
'Restricted State',
'Restricted Industry',
'Prohibited Industry',
'Note',

            // Add other relevant fields here
        ];
    }
}
