<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExtensionExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $lenders;
    public function __construct($extension_list)
    {
        $this->extension_list = $extension_list;
    }
    public function collection()
    {
        // Ensure the lenders data is an array of arrays, where each array is a row of data.
        return collect($this->extension_list)->map(function($extension_list) {
            return [
                $extension_list->extension,
                $extension_list->first_name . ' ' . $extension_list->last_name,
                $extension_list->email,
                " " .'+' . $extension_list->country_code . $extension_list->mobile,
                $extension_list->alt_extension,

                // Add other relevant fields here
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Extension',
            'Name',
            'Email',
            'Phone Number',
            'Web Phone',
            // Add other relevant fields here
        ];
    }
}
