<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class LendersExport implements FromCollection, WithHeadings
{
    /**
    * @return \Illuminate\Support\Collection
    */
    protected $lenders;
    public function __construct($lenders)
    {
        $this->lenders = $lenders;
    }

    public function collection()
    {
        // Ensure the lenders data is an array of arrays, where each array is a row of data.
        return collect($this->lenders)->map(function($lender) {
            return [
                $lender->lender_name,
                $lender->email,
                $lender->secondary_email,
                $lender->contact_person,
                // Add other relevant fields here
            ];
        });
    }

    public function headings(): array
    {
        return [
            'Name',
            'Email',
            'Secondary Email',
            'Contact Person',
            // Add other relevant fields here
        ];
    }
}
