<?php
namespace App\Http\Controllers;
use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use App\Classes\ApiClass;
use File;
use Redirect;
use PDF;
use Carbon\Carbon;


class AffiliateController extends Controller
{
    protected $request;

    public function __construct(Request $request)
    {
        session_start();
        $this->active = request()->segment(5);
        $this->clientId = request()->segment(6);
        $this->extension = request()->segment(7);
        $this->token = request()->segment(8);

    }
    
    public function index(Request $request)
    {
        $active_status = '';
        $unique_token = $this->token;
        $intClientId = ($this->clientId);
        $active = $this->active;
        $extensionId = ($this->extension);


        //documents
        $affiliate_link = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "check-affiliate-link/".$intClientId.'/'.$extensionId.'/'.$unique_token;
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $affiliate_link = $response->data;
                if(empty($affiliate_link))
                {
                    return redirect('/404');
                }
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }


        //documents
        $document_types = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "document-types-list/".$intClientId;
        try
        {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $document_types = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }


        $company_details = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-settings/$intClientId";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success) {
                $company_details = $response->data;
              

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }

         //label
        $labels = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "label-list/".$intClientId;
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $labels = $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }

        $state_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "state-list";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $state_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }



            //echo "<pre>";print_r($lead);die;
        return view("affiliate.index")->with(["labels" => $labels,  'document_types'=>$document_types, 'clientId' => $intClientId,'active_status' => $active_status,'token_url'=>$unique_token,'parent_id' => $intClientId, 'extensionId' => $extensionId, 'active' => $active,'company_details' => $company_details,'document_types' => $document_types,'state_list' => $state_list ]);

    }


    public function personalInfo(Request $request)
    {
        $active_status = '';
        $unique_token = $this->token;
        $intClientId = ($this->clientId);
        $active = $this->active;
        $extensionId = ($this->extension);
        $errors = new MessageBag();
        $company_details = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-settings/$intClientId";

        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $company_details = $response->data;
              

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }

        //documents
        $document_types = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "document-types-list/".$intClientId;
        try
        {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $document_types = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }


        $errors = new MessageBag();

        if($request->submit =='personal_information')
        {

        try
        {

            //echo "<pre>";print_r($this->getBuildBodyLabel($request,$intClientId));die;
            $url = env('API_URL') . "affiliate/lead/add/$intClientId/$extensionId";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBodyLabel($request,$intClientId), "json");
            //echo "<pre>";print_r($response);die;

            if ($response->success) {








                $intLeadId = $response->data->id;
                $_SESSION['lead_id_var'] = $intLeadId;




                $email_template = null;
                $errors = new MessageBag();
                try
                {
                    //$url = env('API_URL') . "crm-custom-template//parent_id/$id/$list_id/$lead_id/pdf"; list id is extensionid
                    $url = env('API_URL') . "crm-custom-template-affiliate/$intClientId/1/$extensionId/$intLeadId/pdf";
                    $response_data = Helper::GetApi($url, [], true);
                    //echo "<pre>";print_r($response);die();
            
                    if ($response_data["success"]) {
                        $email_template = $response_data["data"];

                    } else {
                        foreach ($response_data["errors"] as $key => $message) {
                            $errors->add($key, $message);
                        }
                        //return view("email-template.edit")->withErrors($errors);
                    }
                } catch (RequestException $ex) {
                    return $errors->add("error", $ex->getMessage());
                    //view("email-template.edit")->withErrors($errors);
                }

                // $email_template = $response_data['data']['template_html'];
                    if ($response_data["success"] && isset($response_data["data"]["template_html"])) {
                                                    $email_template = $response_data["data"]["template_html"];
                                                } else {
                                                    foreach ($response_data["errors"] ?? [] as $key => $message) {
                                                        $errors->add($key, $message);
                                                    }

                                                    return redirect()->back()->withInput()->withErrors($errors);
                                                }
                $email_content = $email_template;

                $file_name = $response->data->doc_file_name; //'signed_application_'.time().'.pdf';
                if(\File::exists(public_path('uploads/'.$file_name)))
                {
                    \File::delete(public_path('uploads/'.$file_name));
                }

                $data = [
                    'email_template' => $email_content
                ];
                
                $pdf = PDF::loadView('myPDF', $data)->setPaper('A4', 'portrait')->save('uploads/'.$file_name);
               //return  $pdf = PDF::loadView('myPDF', $data)->setPaper('A4', 'portrait')->download($file_name);
























                //notes and updates
               /*
                $leadId = $response->data->id;
                $notifications = array('lead_id'=> $leadId,'message'=>'created lead <b">manually</b>.');
                $result = (new NotificationController)->add($notifications);
                */
            }

             else
                if (!$response->success)
                {
                    foreach ($response->errors as $key => $message)
                    {
                        if (is_array($message))
                        {
                            foreach ( $message as $index => $strInsideMessage )
                                $errors->add($index, $strInsideMessage);
                        }
                        else
                        {
                            $errors->add($key, $message);
                        }
                    }
                    return redirect()->back()->withInput($request->input())->withErrors($errors);
                }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index")->withErrors($errors);
        }

         $state_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "state-list";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $state_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }

        $active_status = 'document';
        session()->flash("success", "User Personal Details has been updated.Please Submit the Document Details");
        session()->flash("success", "User Personal Details has been updated. Please Submit the Document Details (Lead ID: " . $_SESSION['lead_id_var'] . ")");

        return redirect()->route('affiliate.documents', [
            'client_id' => $intClientId,
            'extension_number' => $extensionId,
            'unique_url' => $unique_token
        ])->with("success", "User Personal Details has been updated. Please submit the Document Details (Lead ID: " . $_SESSION['lead_id_var'] . ")")->with("active_status", $active_status);
        // return view("affiliate.index-documents")->with(['lead_id'=> $_SESSION['lead_id_var'],'company_details' => $company_details,'document_types' => $document_types,'parent_id' => $intClientId, 'document_types'=>$document_types, 'clientId' => $intClientId,'active' => $active_status,'token_url'=>$unique_token,'state_list' => $state_list])->with("success", "Information has been updated");
    }

    else
    {
         if($request->hasfile('file_name'))
            {
                 $active_status = 'document_lists';
                for($i=0;$i<count($request->document_type);$i++)
                {
                    if(!empty($request->type_value[$i]))
                    {
                        $type_value = $request->type_value[$i];
                        $document_type[] = $request->document_type[$i].'-'.$type_value;
                    }
                    else
                    {
                        $document_type[] = $request->document_type[$i];
                    }

                    $document_name[] = $request->document_name[$i];
                }

                $this->validate($request,
                    [
                        'file_name' => 'required',
                        //'file_name' => 'mimes:pdf,jpg,jpeg,png,gif'
                    ]);

                $intLeadId = $_SESSION['lead_id_var'];

                foreach($request->file('file_name') as $key => $file)
                {
                    $size = $file->getSize();
                    $units = array( 'B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB');
                    $power = $size > 0 ? floor(log($size, 1024)) : 0;
                    $file_size =  number_format($size / pow(1024, $power), 2, '.', ',') . ' ' . $units[$power];
                    $rand =rand(1111,9999);
                    $extension = $file->getClientOriginalExtension(); // getting image extension
                    // $filename =  $rand. time() . '.' . $extension;
                     $filename =  $document_type[$key].'_'. time() . '.' . $extension;

                    //$rootPath = env("DOCUMENT_FILE_UPLOAD_PATH");
                    $rootPath = public_path('uploads');
                    $file->move($rootPath, $filename);
                    $request['file_name'] = $filename;
                    $request['lead_id'] = $intLeadId;
                    $request['file_size'] = $file_size;
                    $request['document_name'] = $document_name[$key];
                    $request['document_type'] = $document_type[$key];

                   // echo "<pre>";print_r($request);die;
                    $this->add($request,$intClientId);

                    
                }

                 return Redirect::back()->with("success", "User Personal Details and Documents has been updated (Lead ID: " . $_SESSION['lead_id_var'] . ")");
            }

    }

    }

 


    public function store(Request $request)
    {
        $intClientId = $request->clientId;
        $type = $request->type;
        $url = env('API_URL') . "type-value/$type/$intClientId";
        $response = Helper::GetApi($url, [], true);
        $values =  json_decode($response['data'][0]['values']);
        return response()->json(['success'=>'Data is successfully added','values'=>$values]);
    }


    public function add(Request $request,$intClientId)
    {
        $this->validate($request, ['document_name' => 'required|string|max:255', 'document_type' => 'required|string', 'lead_id' => 'required|int']);
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "save-document-affiliate/$intClientId";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
           // echo "<pre>";print_r($response);die;



            

          if ($response->success) {
                $notifications = array('lead_id'=> $request['lead_id'],'message'=>'Uploaded <b> '.str_replace('_',' ',ucwords($request['document_type'])).' </b>Document information by Affiliate link.');
                    $errors = new MessageBag();
                    try
                    {
                        $intLeadId =$request['lead_id'];
                        $url = env('API_URL') . "add-notification-affiliate/add/$intLeadId/$intClientId";
                        $response = Helper::RequestApi($url, "PUT", $notifications, "json");
                        //echo "<pre>";print_r($response);die;
                        if ($response->success)
                        {
                             session()->flash("success", "Information has been updated");


                           
                        } 
                        else 
                        {
                            foreach ($response->errors as $key => $messages)
                            {
                                if (is_array($messages))
                                {
                                    foreach ($messages as $index => $message)
                                        $errors->add("$key.$index", $message);
                                }
                                else
                                {
                                    $errors->add($key, $messages);
                                }
                            }
                            return redirect()->back()->withInput()->withErrors($errors);
                        }
                    }
                    catch (RequestException $ex)
                    {
                        $errors->add("error", $ex->getMessage());
                        return redirect()->back()->withInput()->withErrors($errors);
                    }


                            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


     private function getBuildBodyLabel(Request $request, $intClientId)
    {
        $errors = new MessageBag();

        //get labels
        $labels = $body = [];
        $url = env('API_URL') . "crm-labels-affiliates/$intClientId";
        try
        {
            $response = Helper::GetApi($url);

            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $labels = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

      //  echo "<pre>";print_r($labels);die;

        foreach($labels as $key => $label){

            if($label->data_type == 'phone_number')
            {
                $number = str_replace(array('(',')', '_', '-',' '), array(''), $request->get($label->column_name));

                $body[$label->column_name] = $number;


            }
            elseif ($label->data_type == 'date')
            {
                $dateInput = $request->get($label->column_name);
                if ($dateInput) {
                    try {
                        // Convert the date to Y-m-d format
                        $formattedDate = Carbon::createFromFormat('m/d/Y', $dateInput)->format('Y-m-d');
                        // Debugging the formatted date
                        \Log::info("Formatted Date: " . $formattedDate);
                        $body[$label->column_name] = $formattedDate;
                    } catch (\Exception $e) {
                        // Handle the exception if date format is not correct
                        \Log::error("Date Parsing Error: " . $e->getMessage());
                        $body[$label->column_name] = null; // or handle it as you see fit
                    }
                } else {
                    $body[$label->column_name] = null;
                }
            }
            else
            {
            $body[$label->column_name] = $request->get($label->column_name);

            }
        }

        $body['lead_status'] = $request->get('lead_status');
        $body['assigned_to'] = $request->get('assigned_to');
        $body['lead_type'] = $request->get('lead_type');
        $body['lead_source_id'] = $request->get('lead_source_id');


         if(!empty($request->signed))
        {

        $folderPath = env("SIGNATURE_FILE_UPLOAD_PATH");

        
        $image_parts = explode(";base64,", $request->signed);
              
        $image_type_aux = explode("image/", $image_parts[0]);
           
        $image_type = $image_type_aux[1];
           
        $image_base64 = base64_decode($image_parts[1]);

        $file_name = uniqid() . '.'.$image_type;
           
        $file = $folderPath . $file_name;
        file_put_contents($file, $image_base64);
            
        $body['signature_image'] = $file_name;
        }

        if(!empty($request->signed2))
        {

        $folderPath2 =env("SIGNATURE_FILE_UPLOAD_PATH") ;

        
        $image_parts = explode(";base64,", $request->signed2);
              
        $image_type_aux = explode("image/", $image_parts[0]);
           
        $image_type = $image_type_aux[1];
           
        $image_base64 = base64_decode($image_parts[1]);

        $file_name2 = uniqid() . '.'.$image_type;
           
        $file2 = $folderPath2 . $file_name2;
        file_put_contents($file2, $image_base64);
            
        $body['owner_2_signature_image'] = $file_name2;
        }
        return $body;
    }


    private function getBuildBody(Request $request)
    {
        $body = ["document_name" => trim(ucwords($request->get("document_name"))),
            "document_type" => $request->get("document_type"),
            "file_name" => $request->get("file_name"),
            "lead_id" => $request->get("lead_id"),
            "file_size" => $request->get("file_size")

            ];
        return $body;
    }


    private function getBuildBodyLead(Request $request, $intClientId)
    {

        
        //get labels
        $labels = $body = [];
        $url = env('API_URL') . "label-list/$intClientId";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $labels = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        foreach($labels as $key => $label){
            if($label->data_type == 'phone_number')
            {
                $number = str_replace(array('(',')', '_', '-',' '), array(''), $request->get($label->column_name));
                $body[$label->column_name] = $number;
            }
      
            else
            {
                $body[$label->column_name] = $request->get($label->column_name);
            }
        }


        if(!empty($request->signed))
        {

        $folderPath = env("SIGNATURE_FILE_UPLOAD_PATH");

        
        $image_parts = explode(";base64,", $request->signed);
              
        $image_type_aux = explode("image/", $image_parts[0]);
           
        $image_type = $image_type_aux[1];
           
        $image_base64 = base64_decode($image_parts[1]);

        $file_name = uniqid() . '.'.$image_type;
           
        $file = $folderPath . $file_name;
        file_put_contents($file, $image_base64);
            
        $body['signature_image'] = $file_name;
        }


        $body['lead_status'] = $request->get('lead_status');
        $body['assigned_to'] = $request->get('assigned_to');
        $body['lead_type'] = $request->get('lead_type');
        $body['lead_source_id'] = $request->get('lead_source_id');
        $body['lead_unique_url'] = $request->get('lead_unique_url');




        return $body;
    }
    public function showDocuments(){
        $active_status = '';
        $unique_token = $this->token;
        $intClientId = ($this->clientId);
        $active = $this->active;
        $extensionId = ($this->extension);
        $errors = new MessageBag();
        $company_details = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-settings/$intClientId";

        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $company_details = $response->data;
              

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }
        $state_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "state-list";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $state_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.add", ["errors" => $errors]);
        }
        //documents
        $document_types = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "document-types-list/".$intClientId;
        try
        {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $document_types = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("merchant.index", ["errors" => $errors]);
        }
        return view("affiliate.index-documents")->with(['lead_id'=> $_SESSION['lead_id_var'],'company_details' => $company_details,'document_types' => $document_types,'parent_id' => $intClientId, 'document_types'=>$document_types, 'clientId' => $intClientId,'active' => $active_status,'token_url'=>$unique_token,'state_list' => $state_list,'extensionId'=>$extensionId])->with("success", "Information has been updated");

    }
    
}


