<?php

namespace App\Http\Controllers\AiSetting;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;
use GuzzleHttp\Client;
class DeleteSmsListController extends Controller
{

    public function index(Request $request){
        $cli_list = [];
        $errors = new MessageBag();
          // Sanitize inputs
          $cli = str_replace(array('(', ')', '_', '-', ' '), '', $request->cli);
          $number = str_replace(array('(', ')', '_', '-', ' '), '', $request->number);
    
        $url = env('API_URL') . "ai-setting/show-sms-list";
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'number' => $number,
            "cli" => $cli,
            "limit" => $request->limit,
    
        );
        //dd($body);
        try
        {
          $data = Helper::PostApi($url,$body);
          //dd($data);
    
          if($data)
          {
            $cli_list = $data->response;
          }
          else
          {
            foreach ($data->errors as $key => $message)
            {
              $errors->add($key, $message);
            }
          }
        }
    
        catch(RequestException $ex)
        {
          $errors->add("error", $ex->getMessage());
          return view('ai-setting.delete-sms', compact('cli_list'));
        }
            
        return view('ai-setting.delete-sms', compact('cli_list'));
    }
  
    public function delete(Request $request)
    {
        $errors = new \Illuminate\Support\MessageBag();
    
        // Sanitize inputs
        $cli = str_replace(['(', ')', '_', '-', ' '], '', $request->cli);
        $number = str_replace(['(', ')', '_', '-', ' '], '', $request->number);
    
        $url = env('API_URL') . "ai-setting/delete-sms";
        $body = [
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'number' => $number,
            'cli' => $cli,
        ];
    
        try {
            $data = Helper::PostApi($url, $body);
            Log::info('API Response', ['data' => $data]);
    
            if (isset($data->response)) {
                return response()->json([
                    'success' => true,
                    'message' => 'SMS deleted successfully.',
                    'response' => $data->response
                ]);
            } else {
                if (isset($data->errors)) {
                    foreach ($data->errors as $key => $message) {
                        $errors->add($key, $message);
                    }
                }
                return response()->json([
                    'success' => false,
                    'message' => 'Failed to delete SMS.',
                    'errors' => $errors->all()
                ], 400);
            }
        } catch (\GuzzleHttp\Exception\RequestException $ex) {
            Log::error('API Request Exception', ['message' => $ex->getMessage()]);
    
            return response()->json([
                'success' => false,
                'message' => 'Failed to delete SMS. Please try again.',
                'error' => $ex->getMessage()
            ], 500);
        }
    }
    
}
    
  

 