<?php

namespace App\Http\Controllers\AiSetting;
use Session;
use App\Helper\Helper;
use GuzzleHttp\Exception\BadResponseException;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Config;
use App\Http\Controllers\Controller;
use GuzzleHttp\Client;
class SmsListController extends Controller
{

 
  
public function index(Request $request){
    $cli_list = [];
    $errors = new MessageBag();
      // Sanitize inputs
      $cli = str_replace(array('(', ')', '_', '-', ' '), '', $request->cli);
      $number = str_replace(array('(', ')', '_', '-', ' '), '', $request->number);

    $url = env('API_URL') . "ai-setting/list-sms";
    $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'number' => $number,
        "cli" => $cli,
        "limit" => $request->limit,

    );
    //dd($body);
    try
    {
      $data = Helper::PostApi($url,$body);
      //dd($data);

      if($data)
      {
        $cli_list = $data->response;
      }
      else
      {
        foreach ($data->errors as $key => $message)
        {
          $errors->add($key, $message);
        }
      }
    }

    catch(RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return view('ai-setting.list-sms', compact('cli_list'));
    }
        
    return view('ai-setting.list-sms', compact('cli_list'));
}
}
    
  

 