<?php

namespace App\Http\Controllers;

use Session;
use App\Helper\Helper;
use Illuminate\Http\Request;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Exception\BadResponseException;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Collection;
use Livewire\Livewire;
use DB;
use Illuminate\Support\MessageBag;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Log;



class ApiDncController extends Controller
{


  public function getDNC(Request $request)
  {
    $errors = new MessageBag();

    // Step 1: Get extension list from API
    $url = env('API_URL') . 'get-client-extension';
    $body = [
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
    ];

    $ext = Helper::PostApi($url, $body);
    $extension_list = ($ext->success == 'true') ? $ext->data : [];

    // Step 2: Handle pagination
    $upper_limit = 10;
    $show = $request->input('show', 10);

    if (in_array($show, [25, 50, 100])) {
      $upper_limit = $show;
    }

    $page = $request->input('page', 1);
    $lower_limit = ($page > 1) ? (($page - 1) * $upper_limit) : 0;

    if ($request->isMethod('post')) {
      $lower_limit = 0;
      $page = 1;
    }

    // Step 3: Extract search term safely
    $searchInput = $request->input('search');
    $searchTerm = is_array($searchInput) ? ($searchInput['value'] ?? null) : $searchInput;

    try {
      // Step 5: Handle DataTables AJAX
      if ($request->ajax()) {
        $api_response = Helper::PostApi(env('API_URL') . 'dnc', [
          'id' => Session::get('id'),
          'token' => Session::get('tokenId'),
          // 'lower_limit' => $lower_limit,
          // 'upper_limit' => $upper_limit,
          'search' => $searchTerm,
        ]);

        if (!isset($api_response->data)) {
          return response()->json([
            'data' => [],
            'recordsTotal' => 0,
            'recordsFiltered' => 0
          ]);
        }

        $dnc_list = $api_response->data;
        $record_count = $api_response->record_count ?? count($dnc_list);
        $index = -1;
        return DataTables::of(collect($dnc_list))
          ->addIndexColumn()
          ->addColumn('action', function ($row) use (&$index) {
            $id = $row->number ?? '';
            $index++;
            return '
                        <a style="cursor:pointer;margin-right:5px;" title="Edit" class="editDnc" data-index="' . $index . '"  data-number="' . $id . '">
                            <i class="fa fa-edit fa-lg"></i>
                        </a>
                        <a style="cursor:pointer;" title="Delete" class="openDncDelete" data-number="' . $id . '">
                            <i class="fa fa-trash-o fa-lg"></i>
                        </a>';
          })
          ->rawColumns(['action'])
          ->make(true);
      }

      // Step 4: Prepare API request for view
      $url = env('API_URL') . 'dnc';
      $body = [
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'lower_limit' => $lower_limit,
        'upper_limit' => $upper_limit,
        'search' => $searchTerm,
      ];

      $dnc = Helper::PostApi($url, $body);

      if (!isset($dnc->data)) {
        Log::error("Missing 'data' in DNC API response", (array) $dnc);
        $dnc_list = [];
        $record_count = 0;
      } else {
        $dnc_list = $dnc->data;
        $record_count = $dnc->record_count ?? count($dnc_list);
      }

      if (!empty($dnc_list)) {
        return view('donotcall.dnc', compact(
          'dnc_list',
          'extension_list',
          'lower_limit',
          'page',
          'record_count',
          'show',
          'searchTerm'
        ))->withErrors($errors);
      } else {
        if (!empty($searchTerm)) {
          return redirect('dnc')->with('error', 'Search term not found');
        } else {
          return view('donotcall.dnc', compact(
            'dnc_list',
            'extension_list',
            'lower_limit',
            'page',
            'record_count',
            'show',
            'searchTerm'
          ))->withErrors($errors);
        }
      }
    } catch (\Exception $e) {
      Log::error("DNC Exception: " . $e->getMessage(), ['trace' => $e->getTraceAsString()]);
      return back()->with('message', "Error code - (dnc): Oops something went wrong :( Please contact your administrator.");
    }
  }






  // function getDNC(Request $request)
  // {
  //   $errors = new MessageBag();
  //   $url = env('API_URL') . 'get-client-extension';
  //   $body = array(
  //     'id' => Session::get('id'),
  //     'token' => Session::get('tokenId'),
  //   );

  //   $ext = Helper::PostApi($url, $body);
  //   if ($ext->success == 'true') {
  //     $extension_list =  $ext->data;
  //   } else {
  //     $extension_list = array();
  //   }

  //   $url = env('API_URL') . 'dnc';
  //   $body = array(
  //     'id' => Session::get('id'),
  //     'token' => Session::get('tokenId'),
  //     // 'lower_limit' => $lower_limit,
  //     //'upper_limit' => $upper_limit,
  //     //      'search' => $searchTerm,

  //   );

  //   $dnc = Helper::PostApi($url, $body);
  //   //echo "<pre>";print_r($dnc);die;

  //   try {
  //     $dnc_list = $dnc->data;
  //     $record_count = $dnc->record_count;


  //     //   // Handle DataTables AJAX request
  //     if ($request->ajax()) {
  //       $start = $request->input('start', 0); // lower_limit
  //       $length = $request->input('length', 10); // upper_limit

  //       $api_response = Helper::PostApi(env('API_URL') . 'dnc', [
  //         'id' => Session::get('id'),
  //         'token' => Session::get('tokenId'),
  //         'lower_limit' => $start,
  //         'upper_limit' => $length,
  //       ]);

  //       if (!isset($api_response->data)) {
  //         return response()->json(['data' => [], 'recordsTotal' => 0, 'recordsFiltered' => 0]);
  //       }

  //       $dnc_list = $api_response->data;
  //       $record_count = $api_response->record_count ?? count($dnc_list);

  //       return DataTables::of(collect($dnc_list))
  //         ->addIndexColumn()
  //         ->addColumn('action', function ($row) {
  //           $id = $row->number ?? ''; // fix here
  //           return '
  //               <a href="javascript:void(0);" title="Edit" class="editLabel" data-id="' . $id . '">
  //                   <i class="fa fa-edit fa-lg"></i>
  //               </a>
  //               <a href="javascript:void(0);" title="Delete" class="openLabelDelete" data-id="' . $id . '">
  //                   <i class="fa fa-trash-o fa-lg"></i>
  //               </a>';
  //         })
  //         ->rawColumns(['action'])
  //         ->with([
  //           'recordsTotal' => $record_count,
  //           'recordsFiltered' => $record_count,
  //         ])
  //         ->make(true);
  //     }



  //     //echo "<pre>";print_r($extension_list);die;

  //     // // Default upper limit
  //     $upper_limit = 10;

  //     // Get selected value from filter
  //     $show = $request->input('show', 10);
  //     if ($show == 25 || $show == 50 || $show == 100) {
  //       $upper_limit = $show;
  //     }

  //     $urlpage = $request->page;

  //     $page = 0;
  //     $lower_limit = 0;

  //     if (!empty($urlpage) && $urlpage > 1) {
  //       $urlpage = $urlpage - 1;
  //       $lower_limit = $urlpage * $upper_limit;
  //     }

  //     if ($request->isMethod('post')) {
  //       $lower_limit = 0;
  //       $page = 1;
  //     }
  //     //$searchTerm = $request->input('search');
  //     if (!empty($dnc_list)) {
  //       return view('donotcall.dnc', compact('dnc_list', 'extension_list', 'lower_limit', 'page', 'record_count', 'show'))->withErrors($errors);
  //     } else {
  //       //  if (!empty($searchTerm)) {
  //       // Search term is not found in the table
  //       return redirect('dnc')->with('error', ' term not found');
  //       //} 
  //       // else {
  //       //   // Table is empty
  //       //   return view('donotcall.dnc', compact('dnc_list', 'extension_list', 'lower_limit', 'page', 'record_count', 'show'))->withErrors($errors);
  //       // }
  //     }
  //   } catch (BadResponseException $e) {
  //     return back()->with('message', "Error code - (dnc): Oops something went wrong :( Please contact your administrator.)");
  //   } catch (RequestException $ex) {
  //     return back()->with('message', "Error code - (dnc): Oops something went wrong :( Please contact your administrator.)");
  //   }
  // }


  function getDNC_old(Request $request)
  {
    $errors = new MessageBag();
    $url = env('API_URL') . 'get-client-extension';
    $body = array(
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
    );

    $ext = Helper::PostApi($url, $body);
    if ($ext->success == 'true') {
      $extension_list =  $ext->data;
    } else {
      $extension_list = array();
    }
    //echo "<pre>";print_r($extension_list);die;

    // Default upper limit
    $upper_limit = 10;

    // Get selected value from filter
    $show = $request->input('show', 10);
    if ($show == 25 || $show == 50 || $show == 100) {
      $upper_limit = $show;
    }

    $urlpage = $request->page;

    $page = 0;
    $lower_limit = 0;

    if (!empty($urlpage) && $urlpage > 1) {
      $urlpage = $urlpage - 1;
      $lower_limit = $urlpage * $upper_limit;
    }

    if ($request->isMethod('post')) {
      $lower_limit = 0;
      $page = 1;
    }
    $searchTerm = $request->input('search');
    $url = env('API_URL') . 'dnc';
    $body = array(
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
      'lower_limit' => $lower_limit,
      'upper_limit' => $upper_limit,
      'search' => $searchTerm,

    );

    $dnc = Helper::PostApi($url, $body);
    //echo "<pre>";print_r($dnc);die;

    try {
      $dnc_list = $dnc->data;
      $record_count = $dnc->record_count;
      if (!empty($dnc_list)) {
        return view('donotcall.dnc', compact('dnc_list', 'extension_list', 'lower_limit', 'page', 'record_count', 'show', 'searchTerm'))->withErrors($errors);
      } else {
        if (!empty($searchTerm)) {
          // Search term is not found in the table
          return redirect('dnc')->with('error', 'Search term not found');
        } else {
          // Table is empty
          return view('donotcall.dnc', compact('dnc_list', 'extension_list', 'lower_limit', 'page', 'record_count', 'show', 'searchTerm'))->withErrors($errors);
        }
      }
    } catch (BadResponseException $e) {
      return back()->with('message', "Error code - (dnc): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
      return back()->with('message', "Error code - (dnc): Oops something went wrong :( Please contact your administrator.)");
    }
  }


  function storeDNC(Request $request)
  {
    if (!empty($request->file('dnc_file'))) {

      $file = $request->file('dnc_file');
      $extension = $file->getClientOriginalExtension(); // getting image extension
      $filename = time() . '.' . $extension;
      $rootPath = '/var/www/html/api/upload/';
      // $rootPath= "C:/xampp/htdocs/uploads/";
      $file->move($rootPath, $filename);

      $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'file' => $filename,
      );
      // echo "<pre>";print_r($body);die;
      $url = env('API_URL') . 'upload-dnc';
      //   $dnc_upload = Helper::PostApi($url,$body);
      // return redirect('/editList/6/5');
      //echo "<pre>";print_r($ext_group);die;
      try {
        $dnc_upload = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($dnc_upload);die;
        if ($dnc_upload->success == 'true') {

          unlink($rootPath . $filename);


          return back()->withSuccess($dnc_upload->message);
        }

        if ($dnc_upload->success == 'false') {
          // return redirect('/');
          return back()->withSuccess($dnc_upload->message);
        }
      } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (upload-dnc): Oops something went wrong :( Please contact your administrator.)");
      } catch (RequestException $ex) {
        return back()->with('message', "Error code - (upload-dnc): Oops something went wrong :( Please contact your administrator.)");
      }
    } else if (!empty($request->dnc)) {

      $number = str_replace(array('(', ')', '_', '-', ' '), array(''), $request->number);



      $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'number' => $number,
        'extension' => $request->extension,

        'comment' => $request->comment
      );

      //echo "<pre>";print_r($body);

      $url = env('API_URL') . 'edit-dnc';
      // echo "<pre>";print_r($body);die;

      //  $add_dnc = Helper::PostApi($url,$body);
      // echo "<pre>";print_r($add_dnc);die;

      try {
        $add_dnc = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($ext_group);die;
        if ($add_dnc->success == 'true') {
          // echo "<pre>";print_r($group);die;
          //return back()->withSuccess($result->message);
          return back()->withSuccess($add_dnc->message);
        }

        if ($add_dnc->success == 'false') {
          // return redirect('/');
          return back()->withSuccess($add_dnc->message);
        }
      } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (edit-dnc): Oops something went wrong :( Please contact your administrator.)");
      } catch (RequestException $ex) {
        return redirect('/');
      }
    } else {

      $number = str_replace(array('(', ')', '_', '-', ' '), array(''), $request->number);
      $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'number' => $number,
        'extension' => $request->extension,

        'comment' => $request->comment
      );

      // echo "<pre>";print_r($body);die;

      $url = env('API_URL') . 'add-dnc';
      //echo "<pre>";print_r($body);die;

      try {
        $ext_group = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($ext_group);die;
        if ($ext_group->success == 'true') {
          // echo "<pre>";print_r($group);die;
          //return back()->withSuccess($result->message);
          return back()->withSuccess($ext_group->message);
        }

        if ($ext_group->success == 'false') {
          return back()->withMessage($ext_group->message);
          //return back()->withSuccess($ext_group->message);
        }
      } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (add-dnc): Oops something went wrong :( Please contact your administrator.)");
      } catch (RequestException $ex) {
        return back()->with('message', "Error code - (add-dnc): Oops something went wrong :( Please contact your administrator.)");
      }
    }
  }

  function editDnc($number)
  {

    $body = array(
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
      'number' => $number,

    );

    // echo "<pre>";print_r($body);die;

    $url = env('API_URL') . 'dnc';
    // echo "<pre>";print_r($body);die;

    $ext_group = Helper::PostApi($url, $body);
    //echo "<pre>";print_r($ext_group);die;

    try {
      $ext_group = Helper::PostApi($url, $body);
      /* echo "<pre>";print_r($ext_group);die;*/
      if ($ext_group->success == 'true') {

        $group = $ext_group->data;

        return $group;
      }

      if ($ext_group->success == 'false') {
        return redirect('/');
        //return back()->withSuccess($ext_group->message);
      }
    } catch (BadResponseException   $e) {
      return back()->with('message', "Error code - (dnc): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
      return back()->with('message', "Error code - (dnc): Oops something went wrong :( Please contact your administrator.)");
    }
  }


  function deleteDnc($number)
  {
    $body = array(
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
      'number' => $number,

    );

    // echo "<pre>";print_r($body);die;

    $url = env('API_URL') . 'delete-dnc';
    //echo "<pre>";print_r($body);die;

    try {
      $delete_dnc = Helper::PostApi($url, $body);
      //echo "<pre>";print_r($ext_group);die;
      if ($delete_dnc->success == 'true') {
        // echo "<pre>";print_r($group);die;
        //return back()->withSuccess($result->message);
        return back()->withSuccess($delete_dnc->message);
      }

      if ($delete_dnc->success == 'false') {
        return redirect('/');
        //return back()->withSuccess($ext_group->message);
      }
    } catch (BadResponseException   $e) {
      return back()->with('message', "Error code - (delete-dnc): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
      return back()->with('message', "Error code - (delete-dnc): Oops something went wrong :( Please contact your administrator.)");
    }
  }


  function uploadExcel()
  {
    $file = $request->file('list_file');
    $extension = $file->getClientOriginalExtension(); // getting image extension
    $filename = time() . '.' . $extension;
    $rootPath = '/var/www/html/api/upload/';
    //$rootPath = 'C:\xampp\htdocs\api\upload\/';
    $file->move($rootPath, $filename);

    $body = array(
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
      'file' => $filename,
    );

    // echo "<pre>";print_r($body);die;

    $url = env('API_URL') . 'add-list';
    // $ext_group = Helper::PostApi($url,$body);

    // return redirect('/editList/6/5');
    // echo "<pre>";print_r($ext_group);die;

    try {
      $add_list = Helper::PostApi($url, $body);
      //echo "<pre>";print_r($ext_group);die;
      if ($add_list->success == 'true') {

        $list_id = $add_list->list_id;
        $campaign_id = $add_list->campaign_id;

        return redirect('/editList/' . $list_id . '/' . $campaign_id);
      }

      if ($add_list->success == 'false') {
        return redirect('/');
        //return back()->withSuccess($ext_group->message);
      }
    } catch (BadResponseException   $e) {
      return back()->with('message', "Error code - (add-dnc): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
      return back()->with('message', "Error code - (add-dnc): Oops something went wrong :( Please contact your administrator.)");
    }
  }
}
