<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Controller;

use App\Helper\Helper;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Http\Request;
use App\Http\Controllers\InheritApiController;
use Carbon\Carbon;
class ApiLogsController extends Controller
{
    
    function getApiLogs(Request $request)
    {
        $lower_limit=0;
        $upper_limit=10;
        $page=0;

            $show = $request->input('show', 10);
            $urlpage = $request->page;
            if (!empty($urlpage)) {
                $page=0;
                $upper_limit=10;
                if ($show == 25 || $show == 50 || $show == 100) {
                $upper_limit = $show;
                 $urlpage = $urlpage - 1;
                 $lower_limit = $urlpage * $show;

                }
  
                else
                    if (!empty($urlpage) && $urlpage > 1)
                {
                    $urlpage = $urlpage - 1;
                    $lower_limit = $urlpage * 10;
                }
                else
                {
                    $lower_limit = 0;
                }
            }
             $upper_limit=$show;
             $urlpage = $urlpage - 1;
             //$lower_limit = $urlpage * $show;

           // dd($upper_limit);

        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leads";
        try {
            $response = Helper::PostApi($url);
          

            if ($response->success) {
                $leads = $response->data;
                //echo'<pre>';print_r($leads); exit;

            } else {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.reports.call-data-report", compact("errors", $errors));
        }
        $lenders = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lenders";
        try {
            $response = Helper::GetApi($url);

            if ($response->success) {
                $lenders = $response->data;
                //echo'<pre>';print_r($lenders); exit;

            } else {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.reports.call-data-report", compact("errors", $errors));
        }
        $clients = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "clients";
        try {
            $response = Helper::GetApi($url);

            if ($response->success) {
                $clients = $response->data;
                //echo'<pre>';print_r($clients); exit;

            } else {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("ringless-voicemail.reports.call-data-report", compact("errors", $errors));
        }
        $report = NULL;
        $errors = new MessageBag();
        $body = array
        (
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lender_api_type' => $request->lender_api_type,
            'businessID' => $request->businessID,
        );
         $url = env('API_URL') . 'api-logs-data';
        try {
            $response = Helper::PostApi($url,$body);
            //echo'<pre>';print_r($record_count); exit;
            if ($response->success) {
                $report = $response->data;
                $record_count=$response->record_count;
               //echo'<pre>';print_r($response); exit;

                session()->flash("success", $response->message);
            } else {
                $errors->add("error", $response->message);
                return view("api-logs", compact("errors", $errors));
            }
        } catch (\Throwable $ex) {
            $errors->add("error", $ex->getMessage());
            return view("api-logs", compact("errors", $errors));
        }
        //dd($page);
        return view("api-logs",compact('report','clients','lenders','leads','show','lower_limit','upper_limit','page','record_count'));
    }
   public function getLog(Request $request){
      
    $leads = [];
    $errors = new MessageBag();
    $url = env('API_URL') . "leads";
    try {
        $response = Helper::PostApi($url);

        if ($response->success) {
            $leads = $response->data;
            //echo'<pre>';print_r($leads); exit;

        } else {
            foreach ( $response->errors as $key => $message ) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("api-logs", compact("errors", $errors));
    }
    $lenders = [];
    $errors = new MessageBag();
    $url = env('API_URL') . "lenders";
    try {
        $response = Helper::GetApi($url);

        if ($response->success) {
            $lenders = $response->data;
            //echo'<pre>';print_r($lenders); exit;

        } else {
            foreach ( $response->errors as $key => $message ) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("api-logs", compact("errors", $errors));
    }
    $clients = [];
    $errors = new MessageBag();
    $url = env('API_URL') . "clients";
    try {
        $response = Helper::GetApi($url);

        if ($response->success) {
            $clients = $response->data;
            //echo'<pre>';print_r($clients); exit;

        } else {
            foreach ( $response->errors as $key => $message ) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("api-logs", compact("errors", $errors));
    }
  
    $urlpage = $request->page; // Current page from the request
    $show = $request->input('show', 10); // Number of entries to show per page, default is 10
    $page = 1;
    $lower_limit = 0;
    $upper_limit = $show; // Default upper limit matches the "show" value
    
    // Adjust upper_limit based on the show value
    if (in_array($show, [10, 25, 50, 100])) {
        $upper_limit = $show;
    }
    
    // Adjust lower_limit and page for pagination
    if (!empty($urlpage) && $urlpage > 1) {
        $page = $urlpage; // Set the current page
        $lower_limit = ($page - 1) * $show; // Calculate lower limit
    } else {
        $page = 1; // Default to the first page
        $lower_limit = 0; // Start from the first record
    }
   

    

    if ($request->isMethod('post')) {
       $lower_limit = 0;
       $page=1;
    }
//dd($upper_limit);

        $body = array
        (
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lender_api_type' => $request->lender_api_type,
            'businessID' => $request->businessID,
        );
        // echo "<pre>"; print_r($body); die;

        $report = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "api-logs-data";

        try {
            $response = Helper::PostApi($url, $body);
            //echo "<pre>"; print_r($response); die;

            if ($response->success) {
                $report = $response->data;
                $record_count=$response->record_count;
                //dd($leads);
            //    echo "<pre>"; print_r($leads); die;
                //session()->flash("success", $report->message);
                //return view('api-logs',compact('report','clients','lenders','leads','record_count','lower_limit','upper_limit','page','show'));
            } else {
                // Handle errors
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }

        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("api-logs", ["errors" => $errors]);
        }

        return view('api-logs',compact('report','clients','lenders','leads','record_count','lower_limit','upper_limit','page','show'));

     }
}
