<?php

namespace App\Http\Controllers;

use Session;
use App\Helper\Helper;
use Illuminate\Http\Request;
use GuzzleHttp\Exception\RequestException;
use App\Http\Controllers\InheritApiController;
use GuzzleHttp\Exception\BadResponseException;
use Yajra\DataTables\Facades\DataTables;


class ApiRecycleController extends Controller
{
  function getRecycleList(Request $request)
  {


    $inherit_list = new InheritApiController;
    $campaign_list =  $inherit_list->getCampaign();

    if (!is_array($campaign_list)) {
      $campaign_list = array();
    }


    $disposition_list =  $inherit_list->getDisposition();
    if (!is_array($disposition_list)) {
      $disposition_list = array();
    }

    $list_details =  $inherit_list->getListList();
    if (!is_array($list_details)) {
      $list_details = array();
    }


    //echo "<pre>";print_r($list_details);die;

    $recycle_list =  $inherit_list->getRecycleRule();

    if (!is_array($recycle_list)) {
      $recycle_list = array();
    }



    if (empty($recycle_list)) {
      if (empty(Session::get('tokenId'))) {
        return redirect('/');
      }
    }


    if ($request->ajax()) {
      return DataTables::of(collect($recycle_list))
        ->addIndexColumn()
        ->addColumn('status', function ($row) {
          $activeClass = isset($row->status) && $row->status == '1' ? '1' : '0';
          return $activeClass;
        })
        ->addColumn('action', function ($row) {
          return '
                <a href="javascript:void(0);" title="Edit" class="editLabel" data-id="' . $row->id . '">
                    <i class="fa fa-edit fa-lg"></i>
                </a>
                <a  title="Delete" class="deleteRecycle" data-id="' . $row->id . '">
                    <i class="fa fa-trash-o fa-lg"></i>
                </a>
                <a style="cursor:pointer;"  href="recycle-rule/{{$recyle->list_id}}/{{$recyle->disposition_id}}" ><i class="fa fa-refresh" aria-hidden="true"></i></a>';
        })
        ->rawColumns(['action'])
        ->make(true);
    }

    //echo "<pre>";print_r($recycle_list);die;


    return view('lists.recycle-rule', compact('campaign_list', 'disposition_list', 'recycle_list', 'list_details'));
  }

  function storeRecycle(Request $request)
  {

    if (empty(Session::get('tokenId'))) {
      return redirect('/');
    }


    $inherit_list = new InheritApiController;
    $campaign_list =  $inherit_list->getCampaign();

    if (!is_array($campaign_list)) {
      $campaign_list = array();
    }

    $list_details =  $inherit_list->getListList();
    if (!is_array($list_details)) {
      $list_details = array();
    }


    $disposition_list =  $inherit_list->getDisposition();
    if (!is_array($disposition_list)) {
      $disposition_list = array();
    }

    if ($request->isMethod('post')) {
      $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'campaign_id' => $request->campaign_id,
        'list_id' =>  $request->list_id,
        'disposition' => $request->disposition_id,
        'time' => $request->time,
        'day' => $request->days,
        'call_time' => $request->call_time,

      );

      //echo "<pre>";print_r($body);die;

      $url = env('API_URL') . 'add-recycle-rule';
      // echo "<pre>";print_r($body);die;



      try {
        $add_recycle = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($recycle_list);die;
        if ($add_recycle->success == 'true') {
          return redirect('/recycle-rule')->withSuccess($add_recycle->message);
        }
        if ($add_recycle->success == 'false') {
          return redirect('/');
          //return back()->withSuccess($ext_group->message);
        }
      } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (add-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
      } catch (RequestException $ex) {
        return back()->with('message', "Error code - (add-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
      }
      // dd($request->all());die;

    }







    return view('lists.add-recycle', compact('campaign_list', 'disposition_list', 'list_details'));
  }


  function editRecycleRule($recycle_id = "", Request $request)
  {


    if ($request->isMethod('post')) {

      $time_explode = explode(":", $request->time);

      $time = $time_explode[0] . ':' . $time_explode[1];

      $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'recycle_rule_id' => $recycle_id,
        'campaign_id' => $request->campaign_id,
        'list_id' =>  $request->list_id,
        'disposition_id' => $request->disposition_id,
        'time' => $time,
        'day' => $request->days,
        'call_time' => $request->call_time,

      );



      $url = env('API_URL') . 'edit-recycle-rule';
      // echo "<pre>";print_r($body);die;

      // $add_recycle = Helper::PostApi($url,$body);
      //echo "<pre>";print_r($add_recycle);die;




      try {
        $add_recycle = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($add_recycle);die;
        if ($add_recycle->success == 'true') {
          return redirect('/recycle-rule')->withSuccess($add_recycle->message);

          // return back()->withSuccess($add_recycle->message);


        }
        if ($add_recycle->success == 'false') {
          return redirect('/recycle-rule')->withError($add_recycle->message);
        }
      } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (edit-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
      } catch (RequestException $ex) {
        return back()->with('message', "Error code - (edit-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
      }
    } else {
      $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'recycle_rule_id' => $recycle_id,
      );


      $url = env('API_URL') . 'recycle-rule';
      // echo "<pre>";print_r($body);die;

      try {
        $recycle_list = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($recycle_list);die;
        if ($recycle_list->success == 'true') {
          $recycle = $recycle_list->data;
        }
        if ($recycle_list->success == 'false') {
          return redirect('/');
          //return back()->withSuccess($ext_group->message);
        }
      } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (recycle-rule): Oops something went wrong :( Please contact your administrator.)");
      } catch (RequestException $ex) {
        return back()->with('message', "Error code - (recycle-rule): Oops something went wrong :( Please contact your administrator.)");
      }

      $inherit_list = new InheritApiController;
      $campaign_list =  $inherit_list->getCampaign();
      if (!is_array($campaign_list)) {
        $campaign_list = array();
      }

      $disposition_list =  $inherit_list->getDisposition();
      if (!is_array($disposition_list)) {
        $disposition_list = array();
      }

      $list_details =  $inherit_list->getListList();
      if (!is_array($list_details)) {
        $list_details = array();
      }

      return view('lists.edit-recycle', compact('campaign_list', 'disposition_list', 'recycle', 'list_details'));
    }
  }

public function deleteRecycleRule($recycle_id = "")
{
    $body = [
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'recycle_rule_id' => $recycle_id,
        'is_deleted' => 1,
    ];

    $url = env('API_URL') . 'edit-recycle-rule';

    try {
        $recycle_list = Helper::PostApi($url, $body);

        if (!empty($recycle_list) && $recycle_list->success == 'true') {
            return response()->json([
                'success' => true,
                'message' => $recycle_list->message ?? 'Recycle rule deleted successfully'
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => $recycle_list->message ?? 'Failed to delete recycle rule'
        ], 400);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Error: ' . $e->getMessage(),
        ], 500);
    }
}


  function findRecycleListDelete($list_id, $disposition_id)
  {
    //echo $list_id;
    //echo $disposition_id;die;

    $body = array(
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
      'list_id' => $list_id,
      'disposition_id' => $disposition_id,
    );


    $url = env('API_URL') . 'delete-leads-rule';
    /*$recycle_list = Helper::PostApi($url,$body);
     echo "<pre>";print_r($recycle_list);die;*/

    try {
      $recycle_list = Helper::PostApi($url, $body);
      //echo "<pre>";print_r($recycle_list);die;
      if ($recycle_list->success == 'true') {
        $count = $recycle_list->data;
        // $inherit_list = new InheritApiController;
        // $sendmail =  $inherit_list->sendMail($count);
        return back()->withSuccess($recycle_list->message);
      }
      if ($recycle_list->success == 'false') {
        return back()->withSuccess($recycle_list->message);
        //return back()->withSuccess($ext_group->message);
      }
    } catch (BadResponseException   $e) {
      return back()->with('message', "Error code - (edit-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
      return back()->with('message', "Error code - (edit-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
    }
  }

  public function searchRecycleRule(Request $request)
  {
    $inherit_list = new InheritApiController;
    $campaign_list = $inherit_list->getCampaign();
    if (!is_array($campaign_list)) $campaign_list = [];

    $disposition_list = $inherit_list->getDisposition();
    if (!is_array($disposition_list)) $disposition_list = [];

    $list_details = $inherit_list->getListList();
    if (!is_array($list_details)) $list_details = [];

    // DataTables parameters
    $draw = $request->input('draw');
    $start = $request->input('start', 0);
    $length = $request->input('length', 10);

    // Your filters from DataTables ajax or your form
    $body = [
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
      'campaign_id' => $request->campaign_id,
      'list_id' => $request->list_id,
      'disposition_id' => $request->disposition_id,
      'call_time' => $request->call_time,
      'day' => $request->days,
      'start' => $start,    // send pagination parameters if your API supports it
      'length' => $length,
    ];

    $url = env('API_URL') . 'search-recycle-rule';

    try {
      $response = Helper::PostApi($url, $body);
     // echo "<pre>";print_r($response);die;

      if ($response->success == 'true') {
        $data = $response->data ?? [];

        // If your API returns total records count separately, use it; else use count of data
        $recordsTotal = property_exists($response, 'total') ? (int) $response->total : count($data);
        $recordsFiltered = $recordsTotal;

        // Format data for DataTables
        // Optionally add DT_RowIndex for serial numbers, or map fields if needed
        $formattedData = [];
            // ✅ Slice manually for DataTables pagination
    $pagedData = array_slice($data, $start, $length);
        foreach ($pagedData as $key => $item) {
          $formattedData[] = [
            'DT_RowIndex' => $start + $key + 1,
            'campaign' => $item->campaign ?? '',
            'list' => $item->list ?? '',
            'disposition' => $item->disposition ?? '',
            'day' => $item->day ?? '',
            'time' => $item->time ?? '',
            'call_time' => $item->call_time ?? '',
            'status' => $item->is_deleted == 0 ? 'Active' : 'Inactive',
           'action' => '
            <a href="edit-recycle/' . $item->id . '"><i class="fa fa-edit fa-lg"></i></a>
            <a  title="Delete" class="deleteRecycle" data-id="' . $item->id . '">
                <i class="fa fa-trash-o fa-lg"></i>
            </a>
            <a style="cursor:pointer;" href="recycle-rule/' . $item->list_id . '/' . $item->disposition_id . '">
                <i class="fa fa-refresh" aria-hidden="true"></i>
            </a>
        ',
            
          ];
        }

        // Return JSON for DataTables
        return response()->json([
          'draw' => intval($draw),
          'recordsTotal' => $recordsTotal,
          'recordsFiltered' => $recordsFiltered,
          'data' => $formattedData,
        ]);
      } else {
        // API returned failure
        return response()->json([
          'draw' => intval($draw),
          'recordsTotal' => 0,
          'recordsFiltered' => 0,
          'data' => [],
          'error' => $response->message ?? 'No data found',
        ]);
      }
    } catch (\Exception $e) {
      return response()->json([
        'draw' => intval($draw),
        'recordsTotal' => 0,
        'recordsFiltered' => 0,
        'data' => [],
        'error' => 'Something went wrong: ' . $e->getMessage(),
      ]);
    }
  }


  function searchRecycleRule_old(Request $request)
  {



    $inherit_list = new InheritApiController;
    $campaign_list =  $inherit_list->getCampaign();

    if (!is_array($campaign_list)) {
      $campaign_list = array();
    }


    $disposition_list =  $inherit_list->getDisposition();
    if (!is_array($disposition_list)) {
      $disposition_list = array();
    }

    $list_details =  $inherit_list->getListList();
    if (!is_array($list_details)) {
      $list_details = array();
    }





    //echo "<pre>";print_r($recycle_list);die;
    $body = array(
      'id' => Session::get('id'),
      'token' => Session::get('tokenId'),
      'campaign_id' => $request->campaign_id,
      'list_id' => $request->list_id,
      'disposition_id' => $request->disposition_id,
      'call_time' => $request->call_time,
      'day' => $request->days,

    );

    // echo "<pre>";print_r($body);die;



    $url = env('API_URL') . 'search-recycle-rule';
    /*  $recycle_list_search = Helper::PostApi($url,$body);
	     echo "<pre>";print_r($recycle_list_search);die;*/

    try {
      $recycle_list_search = Helper::PostApi($url, $body);
      echo "<pre>";
      print_r($recycle_list_search);
      die;
      if ($recycle_list_search->success == 'true') {
        $recycle_list = $recycle_list_search->data;
        return view('lists.recycle-rule', compact('campaign_list', 'disposition_list', 'recycle_list', 'list_details'));
      }
      if ($recycle_list_search->success == 'false') {
        //return redirect('/');
        return back()->withSuccess($recycle_list_search->message);
      }
    } catch (BadResponseException   $e) {
      return back()->with('message', "Error code - (edit-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
      return back()->with('message', "Error code - (edit-recycle-rule): Oops something went wrong :( Please contact your administrator.)");
    }
  }
}
