<?php

namespace App\Http\Controllers;

use Session;
use App\Helper\Helper;
use Illuminate\Http\Request;
use GuzzleHttp\Exception\RequestException;
use App\Http\Controllers\InheritApiController;
use GuzzleHttp\Exception\BadResponseException;
use App\Classes\ApiClass;
use File;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Log;
use Carbon\Carbon;

class ApiSmsController extends Controller
{
    public function getSms()
    {
        if (empty(Session::get('tokenId'))) {
            return redirect('/');
        }

        // $inherit_list = new InheritApiController;
        // $sms_list = $inherit_list->getSmsList();

        // if (!is_array($sms_list)) {
        //     $sms_list = array();
        // }

        // //     echo "<pre>";print_r($sms_list);die;
        // if (empty($sms_list)) {
        //     $sms_list = array();
        //     /* if(empty(Session::get('tokenId'))){
        //       return redirect('/');
        //       } */
        // }
        $url_sms = env('API_URL') . 'sms';
        $sms_list = Helper::GetApi($url_sms);
        //echo "<pre>";print_r($sms_list);die;

        $url = env('API_URL') . 'sms_did_list';
        $group = Helper::GetApi($url);
        //echo "<pre>";print_r($group);die;

        
        return view('sms.sms', compact('sms_list', 'group'));

    }

    public function recentSmsList(){
        $url_sms = env('API_URL') . 'sms';
        $sms_list = Helper::GetApi($url_sms);
        return response()->json($sms_list);

    }

    public function editSms($sms_id)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'sms_id' => $sms_id
        );

        //echo "<pre>";print_r($body);die;
        $url = env('API_URL') . 'sms';
        // echo "<pre>";print_r($body);die
        try {
            $ext_group = Helper::PostApi($url, $body);
            /* echo "<pre>";print_r($ext_group);die; */
            if ($ext_group->success == 'true') {
                $group = $ext_group->data;
                return $group;
            }

            if ($ext_group->success == 'false') {
                return redirect('/');
                //return back()->withSuccess($ext_group->message);
            }
        } 
        catch (BadResponseException $e) {
            return back()->with('message', "Error code - (sms): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {
            return back()->with('message', "Error code - (sms): Oops something went wrong :( Please contact your administrator.)");
        }
    }
    
    public function sendSms(Request $request)
    {
        $mmsurl=NULL;
                 // Validate the request data
    $validator = Validator::make($request->all(), [
        'to' => 'required',
        'from' => 'required',
        'message' => 'required', // Add validation rule for 'message' field
        'created_date' => 'required',
    ]);

    if ($validator->fails()) {
        // Return a more user-friendly response if validation fails
        return response()->json([
            'success' => false,
            'message' => 'Invalid input',
            'errors' => $validator->errors()->toArray(),
        ]);
    }
        if ($request->hasFile('sms_file')) {
            // File upload logic
            $file = $request->file('sms_file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '.' . $extension;
            $rootPath = env("UPLOAD_SMS_URL");
            $file->move($rootPath, $filename);
            $mms_url = $rootPath . $filename;    
            $mmsurl = env('DOMAIN_NAME').'/'.$mms_url;
        }
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'to' => $request->to,
            'from' => $request->from,
            'message' => $request->message,
            'date' => $request->created_date,
            'mms_url'=>$mmsurl,
        );


        Log::info('reached send sms body', ['body' => $body]);
        $url = env('API_URL') . 'send-sms';

  try {
    $sendSms = Helper::PostApi($url, $body);
    Log::info('reached send sms respose', ['sendSms' => $sendSms]);

    // normalize to object
    $resp = is_array($sendSms) ? json_decode(json_encode($sendSms)) : $sendSms;
    Log::info('reached send sms resp', ['resp' => $resp]);

    // 🔥 unwrap "original" if present
    if (isset($resp->original)) {
        $resp = $resp->original;
    }

    // ✅ If response has success=false, return failure immediately
    if (isset($resp->original->success) && $resp->original->success === false) {
        return response()->json([
            'success' => false,
            'message' => $resp->original->message ?? '❌ SMS sending failed',
            'errors'  => $resp->errors ?? null,
        ], 400);
    }

    // ✅ If response has success=true
    if (isset($resp->success) && $resp->success === true) {
        return response()->json([
            'success' => true,
            'message' => $resp->message ?? '✅ SMS sent successfully',
            'data'    => $resp->data ?? null,
        ], 200);
    }

    // Case 2: backend sent error log style
    $isLogShape = isset($resp->level) || isset($resp->level_name) || isset($resp->channel) || isset($resp->datetime);
    if ($isLogShape) {
        return response()->json([
            'success' => false,
            'message' => $resp->message ?? 'Backend error',
            'error'   => $resp
        ], 400);
    }

    // Default = assume success
    return response()->json([
        'success' => true,
        'message' => $resp->message ?? '✅ SMS sent successfully',
        'data'    => $resp
    ], 200);

} catch (\Exception $e) {
    Log::error('Send SMS Exception', [
        'message' => $e->getMessage(),
        'file'    => $e->getFile(),
        'line'    => $e->getLine(),
    ]);

    return response()->json([
        'success' => false,
        'message' => '❌ Exception: ' . $e->getMessage()
    ], 500);
}

        
        
    }

    public function openSmsDetails(Request $request)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'number' => $request->to,
            'did' => $request->from
        );
        
        $url = env('API_URL') . 'sms-by-did';
        try {
            $sms_details = Helper::PostApi($url, $body);
            if ($sms_details->success == 'true') {
                $sms = $sms_details->data;
                return $sms;
            }

            if ($sms_details->success == 'false') {
                return redirect('/');
                //return back()->withSuccess($ext_group->message);
            }
        } catch (BadResponseException $e) {
            return back()->with('message', "Error code - (sms-by-did): Oops something went wrong :( Please contact your administrator.)");
        } catch (RequestException $ex) {
            return back()->with('message', "Error code - (sms-by-did): Oops something went wrong :( Please contact your administrator.)");
        }
    }

    public function smsResponse()
    {
        $response = json_decode(file_get_contents('php://input'));
        //echo "<pre>";print_r($response);die;
        $apiClass = new ApiClass();
        $string = $apiClass->receieveSms($response);
    }

    public function voiceMailREceiver()
    {
        $response['extension']   = $_GET['extension'];
        $response['voicemailno'] = $_GET['voicemailno'];
        //echo "<pre>";print_r($response);die;
        $apiClass = new ApiClass();
        $string = $apiClass->voiceMailReceiver($response);
    }

    public function gextensionLiveCallStatus()
    {
        $response['extension']   = $_GET['extension'];
        //echo "<pre>";print_r($response);die;
        $apiClass = new ApiClass();
        $string = $apiClass->gextensionLiveCallStatus($response);
    }

    public function load_message_popup()
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId')
        );
        $url = env('API_URL') . 'get-sms-email-list';
        $popup_details = Helper::PostApi($url, $body);

        $inherit_list = new InheritApiController;
        $group = $inherit_list->getListById();
        //echo "<pre>";print_r($response);die;

        if (!is_array($group)) {
            $group = array();
        }

        $sms_array = array(
            'sms_data' => $popup_details,
            'c_number' => $group,
            'role' => Session::get('role')
        );

        echo json_encode($sms_array);
        //print_r($popup_details);
    }

    public function load_popup_sms_preview(Request $request)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'sms_tpl_id' => $request->sms_tpl_id,
            'lead_id' => $request->lead_id
        );
        $url = env('API_URL') . 'sms-preview';
        $popup_details = Helper::PostApi($url, $body);
        echo json_encode($popup_details);
    }

    public function load_popup_sms_preview_crm(Request $request)
    {
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'sms_tpl_id' => $request->sms_tpl_id,
            'lead_id' => $request->lead_id
        );
        $url = env('API_URL') . 'sms-preview-crm';
        $popup_details = Helper::PostApi($url, $body);
        echo json_encode($popup_details);
    }

    public function send_sms_dialer(Request $request)
    {
        Log::info('reached data',["data"=>$request->all()]);
        $mmsurl=NULL;
          // Validate the request data
    $validator = Validator::make($request->all(), [
        'to' => 'required',
        'from' => 'required',
        'created_date' => 'required',
    ]);

    if ($validator->fails()) {
        // Return a more user-friendly response if validation fails
        return response()->json([
            'success' => false,
            'message' => 'Invalid input',
            'errors' => $validator->errors()->toArray(),
        ]);
    }
        if ($request->hasFile('sms_file')) {
            // File upload logic
            $file = $request->file('sms_file');
            $extension = $file->getClientOriginalExtension();
            $filename = time() . '.' . $extension;
            $rootPath = env("UPLOAD_SMS_URL");
            $file->move($rootPath, $filename);
            $mms_url = $rootPath . $filename; 
            $mmsurl = env('DOMAIN_NAME').'/'.$mms_url;

        }
        $to = str_replace(array('(',')', '_', '-',' '), array(''), $request->to);
        $body = array(
            'id' => Session::get('id'),
            'token' => Session::get('tokenId'),
            'to' => $to,
            'from' => $request->from,
            'message' => $request->message,
            'date' => $request->created_date,
            'mms_url' => $mmsurl,
        );

         //echo "<pre>";print_r($body);die;

        $url = env('API_URL') . 'send-sms';
        try {
            // Get new jobs or execute a job
            $sendSms = Helper::PostApi($url, $body);
                        //Log::info('reached', ['sendSms' => $sendSms]);

        // echo "<pre>";print_r($sendSms);die;        
   
            // $notifications = [
            //     'lead_id' => $request->lead_id,
            //     'message' => $sendSms->message,
            // ];
            //Log::info('reached', ['notifications' => $notifications]);
            //(new NotificationController)->add($notifications);
      

            return json_encode($sendSms);
        }    catch (BadResponseException $e) {
        // Extract the exact error from API response
        if ($e->hasResponse()) {
            $errorBody = (string) $e->getResponse()->getBody();
            return response()->json([
                'success' => false,
                'message' => 'API Error',
                'error'   => json_decode($errorBody, true) ?? $errorBody,
            ], $e->getResponse()->getStatusCode());
        }

        return response()->json([
            'success' => false,
            'message' => $e->getMessage(),
        ], 500);

    } catch (RequestException $ex) {
        return response()->json([
            'success' => false,
            'message' => $ex->getMessage(),
        ], 500);
    }
    }
}
