<?php

namespace App\Http\Controllers\Blogs;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Carbon\Carbon;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\MessageBag;
use App\Helper\Helper;
use Yajra\DataTables\Facades\DataTables;

class BlogController extends Controller
{
    public function publicIndex(Request $request)
{
    $errors = new MessageBag();
    $apiUrl = env('API_URL') . "blogswithtags";

    try {
        $response = Helper::GetApi($apiUrl);

        if ($response->success) {
            $blogs = $response->data; // keep entire pagination object
          //echo "<pre>";print_r($blogs);die;

        } else {
            $blogs = null;
        }

    } catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $blogs = null;
    }

    return view('website.blogs.public_index', compact('blogs'));
}

 public function publicShow($slug)
{
    $apiUrl = env('API_URL') . "blogs/{$slug}/publicshow";

    // Prepare errors
    $errors = new \Illuminate\Support\MessageBag();
    $blog = null;
    $tags = [];
    $industries = [];
    $recentBlogs = [];

    try {

        $response = Helper::GetApi($apiUrl); 
        //echo "<pre>";print_r($response);die;

        if ($response->success) {

            $data = $response->data;

            $blog = $data->blog;
            $tags = $data->tags;
            $industries = $data->industries;
            $recentBlogs = $data->recentBlogs;

        } else {

            $errors->add('api', $response->message ?? 'Something went wrong.');
        }

    } catch (\Exception $ex) {

        $errors->add('exception', $ex->getMessage());
    }

    // If blog still empty → show 404
    if (!$blog) {
        abort(404);
    }

    return view(
        'website.blogs.public_show',
        compact('blog', 'recentBlogs', 'industries', 'tags')
    )->with('canonicalUrl', url("/blogs/{$blog->id}"));
}

  public function index(Request $request)
{
    $errors = new MessageBag();

    $apiUrl = env('API_URL') . "blogs";

    try {
        $response = Helper::GetApi($apiUrl);

        if (!empty($response->success) && $response->success) {
            $blogs = $response->data ?? [];
        } else {
            $blogs = [];
            if (!empty($response->errors)) {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        }
    }
    catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $blogs = [];
    }

      if ($request->ajax()) {
    return DataTables::of($blogs)
        ->addIndexColumn()

        ->addColumn('image', function ($row) {
            $path = $row->image;
            return '<img src="' . asset($path) . '" width="80">';
        })

        ->addColumn('title', function ($row) {
            return $row->title ?? '-';
        })

        ->addColumn('category', function ($row) {
            return $row->categorySlug ?? '-';
        })

->addColumn('status', function ($row) {
    $published = $row->is_published ?? 0;
    $class = $published ? 'bg-success' : 'bg-danger';
    $text = $published ? 'Published' : 'Draft';

    return '<span 
                class="badge badge-pill badge-status '.$class.'" 
                data-bs-toggle="modal" 
                data-bs-target="#status-'.$row->id.'" 
                data-id="'.$row->id.'" 
                data-status="'.$text.'" 
                data-url="'.route('blogs.index').'">
                '.$text.'
            </span>';
})

        ->addColumn('created_at', function ($row) {
            if (!empty($row->created_at)) {
                return \Carbon\Carbon::parse($row->created_at)->format('Y-m-d');
            }
            return '-';
        })

->addColumn('actions', function ($row) {
    $html = '
    <div class="dropdown table-action">
        <a href="#" class="action-icon" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="fa fa-ellipsis-v"></i>
        </a>
        <div class="dropdown-menu dropdown-menu-right">
            <a class="dropdown-item" href="'.route('blogs.tag', $row->id).'" target="_blank">
                <i class="ti ti-eye text-blue-light"></i> Tags
            </a>
            <a class="dropdown-item" href="'.route('blogs.public.show', $row->slug).'" target="_blank">
                <i class="ti ti-eye text-blue-light"></i> Live Preview
            </a>
            <a class="dropdown-item" href="'.route('blogs.show', $row->id).'">
                <i class="ti ti-eye text-blue-light"></i> View
            </a>
            <a class="dropdown-item" href="'.route('blogs.edit', $row->id).'">
                <i class="fa fa-edit text-blue"></i> Edit
            </a>
            <a class="dropdown-item delete-document-btn" href="#" data-bs-toggle="modal" data-bs-target="#delete_activity'.$row->id.'">
                <i class="ti ti-trash text-danger"></i> Delete
            </a>';

         if (!empty($row->deleted_at)) {
        $html .= '
            <a class="dropdown-item" href="'.route('blogs.restore', $row->id).'">
                <i class="fa fa-refresh text-success"></i> Restore
            </a>';
     }

    $html .= '</div></div>';

    return $html;
})
->rawColumns(['image', 'status', 'actions'])
  
        ->make(true);
}


    return view('blogs.index', compact('blogs', 'errors'));
}



    public function create()
    {
         $errors = new MessageBag();

   
    // Prepare API URL
    $apiUrl = env('API_URL') . "industry";

    // Call API
    try {
        $response = Helper::GetApi($apiUrl); // MUST return JSON (success, data, pagination)

        //echo "<pre>";print_r($response);die;
        if ($response->success) {
            $industry = $response->data; // API returns paginated data
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
            $industry = [];
        }
    }
    catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $industry = [];
    }
        return view('blogs.create',compact('industry'));
    }
    private function handleImageUpload($file, $existingImage = null)
    {
        $path = public_path('uploads/blogs');

        if (!File::exists($path)) {
            File::makeDirectory($path, 0755, true);
        }

        if ($existingImage && File::exists(public_path($existingImage))) {
            File::delete(public_path($existingImage));
        }

        $filename = uniqid() . '.' . $file->getClientOriginalExtension();

        $file->move($path, $filename);

        return 'blog/' . $filename;
    }

 public function store(Request $request)
{
    $errors = new MessageBag();

    try {
        $apiUrl = env('API_URL') . "/blogs/store";

        $imagePath = null;

        // ---- 1. Upload image on FRONTEND ----
        if ($request->hasFile('image')) {

            // Create directory if does not exist
            $uploadPath = public_path('uploads/blogs/');
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            // Generate unique name
            $fileName = time() . '_' . $request->file('image')->getClientOriginalName();

            // Move file
            $request->file('image')->move($uploadPath, $fileName);

            // Path to send to backend
            $imagePath = "/uploads/blogs/" . $fileName;
        }

$categoryInput = $request->input('category');

$categoryId = null;
$categorySlug = null;

if (!empty($categoryInput)) {
    $parts = explode('-', $categoryInput, 2);

    $categoryId = $parts[0] ?? null;      // safe
    $categorySlug = $parts[1] ?? null;    // safe
}

        // ---- 2. Prepare payload for BACKEND (ONLY PATH) ----
        $payload = [
            'title' => $request->title,
            'slug' => $request->slug,
            'content' => $request->content,
            'tags' => $request->tags,
            'seo_title' => $request->seo_title,
            'seo_description' => $request->seo_description,
            'seo_keywords' => $request->seo_keywords,
            'is_published' => $request->is_published,
            'category' => $categoryId,
            'categorySlug' => $categorySlug,
            'image' => $imagePath // <--- Only PATH sent to backend
        ];

        // ---- 3. Call BACKEND API ----
        $response = Helper::PostApi($apiUrl, $payload);
        //echo "<pre>";print_r($response);die;

        if ($response->success) {
            return redirect()->route("blogs.index")
                ->with("success", "Blog created successfully.");
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
        }

    } catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
    }

    return redirect()->back()->withErrors($errors)->withInput();
}



    public function show($id)
    {
        $errors = new MessageBag();

           // Call API
               $apiUrl = env('API_URL') . "blogs/{$id}";

    try {
        $response = Helper::GetApi($apiUrl); // MUST return JSON (success, data, pagination)

       // echo "<pre>";print_r($response);die;
        if ($response->success) {
            $blog = $response->data; // API returns paginated data
                // echo "<pre>";print_r($response);die;

        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
            $blog = [];
        }
    }
    catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $blogs = [];
    }
        return view('blogs.show', compact('blog'));
    }

    public function edit(Request $request,$id)
    {
            $errors = new MessageBag();

           // Call API
               $apiUrl = env('API_URL') . "blogs/{$id}";

    try {
        $response = Helper::GetApi($apiUrl); // MUST return JSON (success, data, pagination)

       // echo "<pre>";print_r($response);die;
        if ($response->success) {
            $blog = $response->data; // API returns paginated data
                // echo "<pre>";print_r($response);die;

        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
            $blog = [];
        }
    }
    catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $blogs = [];
    }
$blogTags = [];
$api = env('API_URL') . "tags/{$id}";

try {
    $response = Helper::GetApi($api);

    if ($response->success) {

        // Correct access
        $blogTags = $response->data->blog->tags;

    } else {
        foreach ($response->errors as $key => $message) {
            $errors->add($key, $message);
        }
        $blogTags = [];
    }
}
catch (\Exception $ex) {
    $errors->add("error", $ex->getMessage());
    $blogTags = [];
}
$tagNames = collect($blogTags)->pluck('name')->implode(',');
        $errors = new MessageBag();

   
    // Prepare API URL
    $apiUrl = env('API_URL') . "industry";

    // Call API
    try {
        $response = Helper::GetApi($apiUrl); // MUST return JSON (success, data, pagination)

        //echo "<pre>";print_r($response);die;
        if ($response->success) {
            $industry = $response->data; // API returns paginated data
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
            $industry = [];
        }
    }
    catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $industry = [];
    }
        return view('blogs.edit', compact('blog','blogTags','tagNames','industry'));
    }

  public function update(Request $request,$id)
{
    $errors = new MessageBag();

    try {
        $apiUrl = env('API_URL') . "blogs/{$id}";

        $imagePath = null;

        // ---- 1. Upload image on FRONTEND ----
        if ($request->hasFile('image')) {

            // Create directory if does not exist
            $uploadPath = public_path('uploads/blogs/');
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

        if (File::exists(public_path($uploadPath))) {
            File::delete(public_path($uploadPath));
        }
            // Generate unique name
            $fileName = time() . '_' . $request->file('image')->getClientOriginalName();

            // Move file
            $request->file('image')->move($uploadPath, $fileName);

            // Path to send to backend
            $imagePath = "/uploads/blogs/" . $fileName;
        }
    // ---- 2. Parse category ----
        $categoryId = null;
        $categorySlug = null;
     $categoryInput = $request->input('category');
    //dd($categoryInput);
        if (!empty($categoryInput)) {
            [$categoryId, $categorySlug] = explode('-', $categoryInput, 2);
            $validated['category'] = $categoryId;
            $validated['categorySlug'] = $categorySlug;
        }
        //dd($categorySlug);


        // ---- 2. Prepare payload for BACKEND (ONLY PATH) ----
        $payload = [
            'title' => $request->title,
            'slug' => $request->slug,
            'content' => $request->content,
            'tags' => $request->tags,
            'seo_title' => $request->seo_title,
            'seo_description' => $request->seo_description,
            'seo_keywords' => $request->seo_keywords,
            'is_published' => $request->is_published,
            'category' => $categoryId,
            'categorySlug' => $categorySlug,
            'image' => $imagePath // <--- Only PATH sent to backend
        ];
        //echo "<pre>";print_r($payload);die;

        // ---- 3. Call BACKEND API ----
        $response = Helper::PostApi($apiUrl, $payload);
        //echo "<pre>";print_r($response);die;

        if ($response->success) {
            return redirect()->route("blogs.index")
                ->with("success", "Blog updated successfully.");
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
        }

    } catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
    }

    return redirect()->back()->withErrors($errors)->withInput();
}

    public function destroy($id)
{
    $errors = new MessageBag();

    $apiUrl = env('API_URL') . "blogs/delete/{$id}";

    try {
        $response = Helper::PostApi($apiUrl);

        if ($response->success) {
            // Deleted successfully
            return redirect()
                ->route('blogs.index')
                ->with('success', 'Blog deleted successfully.');
        } else {
            // API returned an error
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }

            return redirect()
                ->route('blogs.index')
                ->with('error', 'Failed to delete blog.');
        }

    } catch (\Exception $ex) {

        return redirect()
            ->route('blogs.index')
            ->with('error', 'Unable to delete blog: ' . $ex->getMessage());
    }
}


   public function restore($id)
{
    $errors = new MessageBag();
    $apiUrl = env('API_URL') . "blogs/restore/{$id}";

    try {
        $response = Helper::PostApi($apiUrl);
        //echo "<pre>";print_r($response);die;

        if (!$response->success) {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }

            return redirect()
                ->route('blogs.index')
                ->withErrors($errors)
                ->with('error', 'Failed to restore blog.');
        }

    } catch (\Exception $ex) {

        $errors->add('error', $ex->getMessage());

        return redirect()
            ->route('blogs.index')
            ->withErrors($errors)
            ->with('error', 'Something went wrong while restoring.');
    }

    return redirect()
        ->route('blogs.index')
        ->with('success', 'Blog restored successfully.');
}



 public function toggleStatus(Request $request, $id)
{
    $errors = new MessageBag();

    try {
        $apiUrl = env('API_URL') . "blogs/toggle-status/{$id}";

        $payload = [
            'is_published' => $request->is_published,
        ];

        // Call API
        $response = Helper::PostApi($apiUrl, $payload);

        if (!$response->success) {
            foreach ($response->errors as $key => $msg) {
                $errors->add($key, $msg);
            }
            return back()->withErrors($errors);
        }

        return redirect()
            ->route('blogs.index')
            ->with('success', 'Blog status updated successfully.');

    } catch (\Exception $e) {
        $errors->add('error', $e->getMessage());
        return back()->withErrors($errors);
    }
}

  public function tag($id)
{
    $errors = new MessageBag();
    $blog = null;
    $tags = [];

    $api = env('API_URL') . "tags/{$id}";

    try {
        $response = Helper::GetApi($api);

        if ($response->success) {
            $blog = $response->data->blog;   // ✔ Correct path
            $tags = $blog->tags;             // ✔ Contains tags array
        } 
        else {
            foreach ($response->errors as $msg) {
                $errors->add('error', $msg);
            }
        }
    }
    catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
    }

    return view('blogs.tags', compact('blog', 'tags'))->withErrors($errors);
}
public function fetchBlogs(Request $request)
{
    $errors = new MessageBag();
    $apiUrl = env('API_URL') . "fetchblogs?page=" . $request->page;

    try {
        $response = Helper::GetApi($apiUrl);

        if (!$response->success) {
            return response()->json([
                'blogs' => [],
                'current_page' => 1,
                'last_page' => 1,
                'has_more' => false
            ]);
        }

        // Pagination object
        $blogs = $response->data;

        return response()->json([
            'blogs'        => $blogs->data,          // items[] inside pagination
            'current_page' => $blogs->current_page,
            'last_page'    => $blogs->last_page,
            'has_more'     => ($blogs->current_page < $blogs->last_page),
        ]);

    } catch (\Exception $ex) {

        return response()->json([
            'blogs' => [],
            'current_page' => 1,
            'last_page' => 1,
            'has_more' => false
        ]);
    }
}





   public function searchBlogs(Request $request)
{
    $errors = new MessageBag();
    $query = $request->search;

    $apiUrl = env('API_URL') . "searchblogs?search=" . urlencode($query);

    try {
        $response = Helper::GetApi($apiUrl);

        if (!$response->success) {
            return response()->json([
                'blogs' => [],
                'count' => 0,
                'message' => 'No blogs found.'
            ]);
        }

        return response()->json([
            'blogs'  => $response->blogs,  // same key from backend
            'count'  => $response->count,
            'message'=> $response->message
        ]);

    } catch (\Exception $ex) {

        return response()->json([
            'blogs' => [],
            'count' => 0,
            'message' => 'Something went wrong.'
        ]);
    }
}
public function show_blogbytag($slug)
{
    

    return view('website.blogs.blogs_by_tag', [
        'slug' => $slug
    ])->with('noindex', true);
}


  public function fetchBlogs_bytags(Request $request)
{ 
    $errors = new MessageBag();
    $slug = $request->query('slug');  // Get slug from query param

    $apiUrl = env('API_URL') . "blogs-by-tag/" . $slug;

    try {
        $response = Helper::GetApi($apiUrl);

        if ($response->success) {

            $pagination = $response->data;   // full pagination object
            $blogs      = $pagination->data; // array of blogs

        } else {
            $blogs = [];
            $pagination = null;
        }

    } catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $blogs = [];
        $pagination = null;
    }

    return response()->json([
        'blogs'        => $blogs,                        // array of blog items
        'current_page' => $pagination->current_page ?? 1,
        'last_page'    => $pagination->last_page ?? 1,
        'has_more'     => isset($pagination) 
                            ? ($pagination->current_page < $pagination->last_page)
                            : false,
    ]);
}


    public function  show_blog_industry_wise($slug)
    {
        return view('website.blogs.blogs_by_industry', ['slug' => $slug]);
    }
    public function fetch_blog_industry_wise(Request $request)
{
    $slug = $request->query('slug');
    Log::info('response', ['slug' => $slug]);

    $apiUrl = env('API_URL') . "blogs-by-industry/" . $slug;

    try {
        $response = Helper::GetApi($apiUrl);
        Log::info('response', ['response' => $response]);

        if ($response->success) {
            $pagination = $response->data;      // full pagination object
            $blogs = $pagination->data;         // array of blogs
        } else {
            $blogs = [];
            $pagination = null;
        }

    } catch (\Exception $ex) {
        Log::error('API Error', ['error' => $ex->getMessage()]);
        $blogs = [];
        $pagination = null;
    }

    if (!$pagination) {
        return response()->json([
            'blogs' => [],
            'current_page' => 1,
            'last_page' => 1,
            'has_more' => false,
        ]);
    }

    return response()->json([
        'blogs'        => $blogs,
        'current_page' => $pagination->current_page,
        'last_page'    => $pagination->last_page,
        'has_more'     => $pagination->current_page < $pagination->last_page,
    ]);
}

    public function  fetch_blog_industry_wise1(Request $request)
    {
      $errors = new MessageBag();
        $slug = $request->query('slug');  // Get slug from query param
        Log::info('response',['slug'=>$slug]);

    $apiUrl = env('API_URL') . "blogs-by-industry/" . $slug;

    try {
        $response = Helper::GetApi($apiUrl);
        Log::info('response',['response'=>$response]);
        //echo "<pre>";print_r($response);die;

        if ($response->success) {
            $blogs = $response->data->data; // pagination data
            $pagination = $response->data;
        } else {
            $blogs = [];
            $pagination = null;
        }

    } catch (\Exception $ex) {
        $errors->add("error", $ex->getMessage());
        $blogs = [];
        $pagination = null;
    }

     return response()->json([
            'blogs'        => $blogs->data,          // items[] inside pagination
            'current_page' => $blogs->current_page,
            'last_page'    => $blogs->last_page,
            'has_more'     => ($blogs->current_page < $blogs->last_page),
        ]);
    }


//     public function uploadImage(Request $request)
//     {
// if ($request->hasFile('upload')) {
//         $file = $request->file('upload');
//         $filename = time().'_'.$file->getClientOriginalName();
//         $file->move(public_path('blog'), $filename);

//         $url = asset('blog/'.$filename);
//         $funcNum = $request->input('CKEditorFuncNum');

//         return response("<script>window.parent.CKEDITOR.tools.callFunction($funcNum, '$url', '');</script>")
//                ->header('Content-Type', 'text/html; charset=utf-8');
//     }
// }
}
