<?php

namespace App\Http\Controllers;
use Session;
use App\Helper\Helper;
use Illuminate\Support\Facades\Input;
use Illuminate\Http\Request;
use  Validator;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Log;







class BuyNoAreaCodeController extends Controller
{

  function index(Request $request){
    $areacode_list = [];
    $errors = new MessageBag();
    $url = env('API_URL') . "area-code-list";
    try {
        $response = Helper::GetApi($url);
        if ($response->success) {
            $areacode_list = $response->data;
        } else {
            $areacode_list = [];
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return view("clients.list", compact("errors", $errors));
    }

    return view('did.buy_areacode',compact('areacode_list'));
  }


  public function getDidListForAreaCode(Request $request) {
      
      $body = array(
          'id' => Session::get('id'),
          'token' => Session::get('tokenId'),
          'data' => $request->all(),
        );
        Log::info('result',['body'=>$body]);

        $url = env('API_URL') . 'get-did-list-for-areacode';
        
        try {
            ini_set('max_execution_time', 300); // 300 seconds = 5 minutes
            $response = Helper::PostApi($url, $body);
            // Log::info('result',['response'=>$response]);
            return $response;

    } catch (Exception $e) {
        return response()->json("Something went wrong!!", 500);
    }
}
public function buyDidAreacode(Request $request) {

    $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'data' => $request->all(),
    );
    $url = env('API_URL') . 'buy-save-selected-did-areacode';

    try {
        $response = Helper::PostApi($url, $body);
        return response()->json($response);
    } catch (Exception $e) {
        return response()->json("Something went wrong!!", 500);
    }
}
}

