<?php

namespace App\Http\Controllers;
use Session;
use App\Helper\Helper;
use Illuminate\Http\Request;
use GuzzleHttp\Exception\RequestException;
use App\Http\Controllers\InheritApiController;
use Illuminate\Support\Facades\Storage;
use GuzzleHttp\Exception\BadResponseException;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\MessageBag;
use Exception;
use InvalidArgumentException;
use File;
use Illuminate\Support\Facades\View;

class ChatAiController extends Controller 
{
    public function sendSms(Request $request)
    {
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "chat-ai-setting";

        try {
            $response = Helper::GetApi($url);
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("chat-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;
        
        $introduction = $open_ai_setting[0]->introduction;
        $description = $open_ai_setting[0]->description;


        $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
        $sendSms = $TELNYX_SMS_AI_URL.'chat/send';

                        /*$json='{"message":"Chat Sent","response":{"user_id":"c34a793c-d842-4308-8ee6-20beceff008a","customer_id":"CUSTOMER-09e96374-956d-4faa-9549-ebbf3ad7556f","text":"Its Rohit with FMB. With the beginning of the year, businesses everywhere are looking to rev up their performance, and we re here to help make it happen. How much can you use at this time?"}}';


                        return $json;*/


        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $sendSms);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);

        $array = ['customer_id' => '', 'introduction' => $introduction,'description' => $description];
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($array));
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;

    return $count_sms_history;
    }

    public function demo()
    {
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "chat-ai-setting";

        try
        {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("chat-ai.update-setting", ["errors" => $errors]);
        }

        return view('chat-ai.list',['open_ai_setting'=>$open_ai_setting]);
    }

    public function openAISetting(Request $request)
    {
        $this->validate($request, [
            'cli'      => 'required',
            "introduction"    => "required",
            "description"          => "required",
            "access_token"          => "required",

        ]);

        $errors = new MessageBag();

        try
        {
            $url = env('API_URL') . "add-chat-ai-setting";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                session()->flash("success", "Chat AI Values created");
                return redirect("chat-ai");
            } else {
                foreach ( $response->errors as $key => $messages ) {
                    if (is_array($messages)) {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


    public function add(Request $request)
    {
        $errors = new MessageBag();    
        if((!empty($request->open_ai_id)))
        {
            try
            {

                // /dd($this->getBuildBody($request));
                $url = env('API_URL') . "update-chat-ai-setting/$request->open_ai_id";
                $response = Helper::PostApi($url, $this->getBuildBody($request));
                //echo "<pre>";print_r($response);die;

                if (!$response->success) {
                    foreach ( $response->errors as $key => $messages )
                    {
                        if (is_array($messages))
                        {
                            foreach ( $messages as $index => $message )
                                $errors->add("$key.$index", $message);
                        }
                        else
                        {
                            $errors->add($key, $messages);
                        }
                    }

                    return redirect()->back()->withInput($request->input())->withErrors($errors);
                }
            } catch (RequestException $ex) {
                $errors->add("error", $ex->getMessage());
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
            session()->flash("success", "SMS AI System Setting updated");
            return redirect()->back();
        }

        try
        {
            $url = env('API_URL') . "add-chat-ai-setting";
            $response = Helper::RequestApi($url, "POST", $this->getBuildBody($request), "json");
          //  echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                session()->flash("success", "Chat AI Setting Added");
                return redirect("/chat-ai-setting");
            }
            else
            {
                foreach ( $response->errors as $key => $messages )
                {
                    if (is_array($messages))
                    {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    public function index(Request $request)
    {
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "chat-ai-setting";

        try {

            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("chat-ai.update-setting", ["errors" => $errors]);
        }
        return view('chat-ai.update-setting',['open_ai_setting' => $open_ai_setting]);
    }

    private function getBuildBody(Request $request)
    {

        $number = str_replace(array('(',')', '_', '-',' '), array(''), $request->cli);

        $body = [
            'introduction'=> $request->get("introduction"),
            'description'=>$request->get('description'),
            'access_token'=>$request->get('access_token')];
            return $body;
    }

    


    public function getChatCountsunread(Request $request)
    {
        //$merchant = $request->merchant_number;

        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "chat-ai-setting";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;
       // $cli = '1'.$open_ai_setting[0]->cli;
        //$cli = $open_ai_setting[0]->cli;

        $introduction = $open_ai_setting[0]->introduction;
        $description = $open_ai_setting[0]->description;
        //$api_url = $open_ai_setting[0]->sms_ai_api_url;
        //$webhook_url = $open_ai_setting[0]->webhook_url;



        


        $sms_ai_history = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "chat-ai-history";

        $body=array('customer_id'=>$request->customer_id);

           



        try
        {
          $response_data = Helper::PostApi($url,$body);
            //echo "<pre>";print_r($body);die;
            if ($response_data->success) {
                $sms_ai_history = $response_data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("chat-ai.update-setting", ["errors" => $errors]);
        }

        return json_encode($sms_ai_history);

        

    }

    public function sendTextToAi(Request $request)
    {
        $sms_ai_history = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "send-text-to-ai";

        $body=array('text'=>$request->text,'customer_id'=>$request->customer_id);

           



        try
        {
          $response_data = Helper::PostApi($url,$body);
            echo "<pre>";print_r($response_data);die;
            if ($response_data->success) {
                $sms_ai_history = $response_data;
            } else {
                foreach ($response_data->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        return json_encode($sms_ai_history);

    }


       public function flushCache()
    {
        $open_ai_setting = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "chat-ai-setting";
        try
        {
            $response = Helper::GetApi($url);
          //  echo "<pre>";print_r($response);die;
            if ($response->success) {
                $open_ai_setting = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("open-ai.update-setting", ["errors" => $errors]);
        }

        $access_token = $open_ai_setting[0]->access_token;


        //flush cache api
        $TELNYX_SMS_AI_URL   = env('TELNYX_SMS_AI_URL');
        $flushCache = $TELNYX_SMS_AI_URL.'sms/flush-cache-chat';
         $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $flushCache);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'DELETE');
       curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'accept: application/json',
            'x-api-key: '.$access_token,
            'Content-Type: application/json',
        ]);
        $response = curl_exec($ch);
        curl_close($ch);

       // echo "<pre>";print_r($response);die;

        session()->flash("success", "All cache erased For SMS AI");
                return redirect("/chat-ai-setting");

    }


  

   
}
