<?php
namespace App\Http\Controllers;
use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestMail;
use App\User;




class CrmCustomTemplateController extends Controller
{
    public function index(Request $request)
    {
        $email_templates = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-custom-templates";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $email_templates = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("crm-custom-template.list", ["errors"=> $errors]);
        }

        //echo "<pre>";print_r($email_templates);die;
        return view("crm-custom-template.list", ["email_templates"=> $email_templates]);
    }

    public function showNew(Request $request)
    {

        $template_types = [];
        $errors = new MessageBag();
        

        $label_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $label_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("configuration.crm-label", ["errors" => $errors]);
        }
        $document_types = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "document-types";
        
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $document_types = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leadstatus.list", ["errors" => $errors]);
        }

        $users = new User();
        $user_column = $users->getTableColumns();

        $company_columns = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "company-columns";
        
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $company_columns = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leadstatus.list", ["errors" => $errors]);
        }


        //echo "<pre>";print_r($company_columns);die;

        return view("crm-custom-template.add")->with(['template_types' => $template_types, 'document_types' => $document_types,'label_list' => $label_list,'user_column' => $user_column, 'company_columns' => $company_columns]);
    }

    public function add(Request $request)
    {
        $this->validate($request, [
            'template_name' => 'required|string|max:255',
            'template_html' => 'required|string',
            //'subject' => 'required|string|max:255',
        ]);

        //echo "<pre>";print_r($this->getBuildBody($request));die;
        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "crm-add-custom-template";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                session()->flash("success", "Custom Template Added");
                return redirect("/crm-custom-templates");
            }
            else
            {
                foreach ( $response->errors as $key => $messages )
                {
                    if (is_array($messages))
                    {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


    public function show(Request $request, int $id)
    {
        $email_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "crm-custom-template/$id";
            $response = Helper::GetApi($url, [], true);
            //echo "<pre>";print_r($response);die;

            if ($response["success"]) {
                $email_template = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("crm-custom-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("crm-custom-template.edit")->withErrors($errors);
        }

        $label_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $label_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("configuration.crm-label", ["errors" => $errors]);
        }
        $document_types = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "document-types";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $document_types = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leadstatus.list", ["errors" => $errors]);
        }

        $template_types = [];
        $errors = new MessageBag();
        // $url = env('API_URL') . "template-types";
        // try
        // {
        //     $response = Helper::GetApi($url);
        //     if ($response->success)
        //     {
        //         $template_types = $response->data;
        //     }
        //     else
        //     {
        //         foreach ( $response->errors as $key => $message )
        //         {
        //             $errors->add($key, $message);
        //         }
        //     }
        // }
        // catch (RequestException $ex)
        // {
        //     $errors->add("error", $ex->getMessage());
        //     return view("template-types.list", ["errors" => $errors]);
        // }

        $users = new User();
        $user_column = $users->getTableColumns();
            //echo "<pre>";print_r($response);die;


        $company_columns = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "company-columns";
        
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $company_columns = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leadstatus.list", ["errors" => $errors]);
        }

        return view("crm-custom-template.edit")->with(['template_types'=> $template_types, 'email_template'=>$email_template,'document_types' => $document_types,'label_list' => $label_list,'user_column' => $user_column, 'company_columns' => $company_columns]);
    }

    public function update(Request $request, int $id)
    {
        $this->validate($request, [
            'template_name' => 'required|string|max:255',
            'template_html' => 'required|string',
          //  'subject' => 'required|string|max:255',
        ]);

        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "crm-custom-template/$id";
            $response = Helper::PostApi($url, $this->getBuildBody($request));

            //echo "<pre>";print_r($response);die;
            if (!$response->success) {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Custom Template Updated");
        return redirect("/crm-custom-templates");
    }

    public function delete(Request $request, $id)
    {
        $url = env('API_URL') . "crm-delete-custom-template/$id";
        $response = Helper::RequestApi($url, "GET");
        if ($response->success)
        {
            session()->flash("success", $response->message);
            return redirect("/crm-custom-templates");
        }
        else
        {
            session()->flash("message", $response->message);
            return redirect("/crm-custom-templates");

        }
    }


    public function changeCustomTemplateStatus($email_template_id = "",  $status = "")
    {
        $body = array('email_template_id' => $email_template_id,'status' => $status);
        $url = env('API_URL') . 'crm-change-custom-template-status';
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($body);die;
        if ($response->success)
        {
            session()->flash("success", $response->message);
            echo json_encode(array('status' => "true", 'message' =>  $response->message));
        }
        else
        {
            session()->flash("message", $response->message);
            echo json_encode(array('status' => "false", 'message' =>  $response->message));
        }
    }

    private function getBuildBody(Request $request)
    {
        $body =[
            "template_name" => trim(($request->get("template_name"))),
            "template_html" => trim(($request->get("template_html"))),
            "custom_type" => ($request->get("custom_type")),
            //"send_bcc" => ($request->get("send_bcc"))

        ];
        return $body;
    }

    public function checkSMTPSetting(Request $request)
    {
        try
        {
            //var_dump($request->all());die;
            $config = array
            (
                'driver'     =>     $request->mail_driver,
                'host'       =>     $request->mail_host,
                'port'       =>     $request->mail_port,
                'username'   =>     $request->mail_username,
                'password'   =>     $request->mail_password,
                'encryption' =>     $request->mail_encryption,
            );

            $toEmail = session()->get('emailId');
            Config::set('mail', $config);

            $address = $request->from_email ?? "test@cafmotel.com";
            $name = $request->from_name ?? "Email Test";

            \Mail::to($toEmail)->send(new TestMail(['address' => $address,'name' => $name], 'Email Setting Test Mail'));
            Log::info("successcheckSMTPSetting", ["success"=>true,"message" => $config]);
            return response()->json(["success" => true, "message" => $config]);
        }

        catch (\Throwable $throwable)
        {
            Log::error("errorcheckSMTPSetting", ["message" => $throwable->getMessage(),"file" => $throwable->getFile(),"line" => $throwable->getLine()]);
            return response()->json(["success" => false, "message" => $throwable->getMessage()]);
        }
    }
}


