<?php

namespace App\Http\Controllers;

use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Collection;
use App\Http\Controllers\InheritApiController;
use Illuminate\Support\Facades\Log;
use App\Exports\LeadsExport;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;
use Carbon\Carbon;   // ✅ Import Carbon

class CrmDashboardController extends Controller
{
    public function showDashboard(){
        // Controller example
$showDashboard1 = $request->input('dashboard_toggle', true);

if ($showDashboard1) {
    return view('dashboard.dashboard', compact('mca_crm_enable'));
} else {
    return view('dashboard.crm-dashboard', compact('mca_crm_enable'));
}

    }
public function view(Request $request)
{
    $errors = new MessageBag();
    $users = [];
    $arrUsersRekeyed = [];
    $arrLeadStatusRekeyed = [];
    $view_on_leads = [];
    $leads = [];
    $record_count = 0;

    try {
        // Fetch users
        $url = env('API_URL') . "users";
        $response = Helper::GetApi($url);
        if ($response->success) {
            $users = (array) $response->data;
            $arrUsersRekeyed = Helper::rekeyArray($users, 'id');
        }

        // Fetch leads
        $body = [
            'level'        => Session::get('userLevel'),
            'start_date'   => $request->start_date,
            'end_date'     => $request->end_date,
            'id'           => Session::get('id'),
            'lead_status'  => $request->lead_status,
            'first_name'   => $request->first_name,
            'last_name'    => $request->last_name,
            'email'        => $request->email,
            'company_name' => $request->company_name,
            'assigned_to'  => $request->assigned_to,
            'lead_type'    => $request->lead_type,
            'phone_number' => $request->phone_number,
            'crm_id'       => $request->crm_id,
            'dba'          => $request->dba,
        ];

        $url = env('API_URL') . "leads";
        $response = Helper::PostApi($url, $body);
        $record_count=$response->record_count;

        if ($response->success) {
            $leads = $response->data;
            $record_count = $response->record_count;
        }

        // Fetch view_on_leads (dynamic columns)
        $url = env('API_URL') . "crm-view-on-leads";
        $response = Helper::GetApi($url);
        if ($response->success) {
            $view_on_leads = (array) $response->data;
        }

        // Fetch lead statuses
        $url = env('API_URL') . "leadStatus";
        $response = Helper::GetApi($url);
        if ($response->success) {
            $lead_status = (array) $response->data;
            $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
        }

    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
        return response()->json(['errors' => $errors], 500);
    }
 $sortedUsers = $this->groupAndSortUsers($users);
              $lead_status_count = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "dashboard-lead-status";
        //echo "<pre>";print_r($url);die;

        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $lead_status_count = (array)$response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("dashboard.crm-dashboard", ["errors" => $errors]);
        }
  $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $lead_status = (array) $response->data;
                $filteredLeadStatus = [];

foreach ($lead_status as $le) {
    // Assuming $lead is an object with a property named 'view_on_dashboard'
    if (isset($le->view_on_dashboard) && $le->view_on_dashboard == 1) {
        $filteredLeadStatus[] = $le;
    }
}
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }
    // If AJAX request (DataTables server-side)
    if ($request->ajax()) {
        return DataTables::of($leads)
            ->addColumn('lead_type', function ($lead) {
                if ($lead->lead_type === 'hot') return '<span class="badge bg-danger">Hot</span>';
                if ($lead->lead_type === 'warm') return '<span class="badge bg-warning text-dark">Warm</span>';
                if ($lead->lead_type === 'cold') return '<span class="badge bg-primary">Cold</span>';
                return '';
            })
            ->addColumn('lead_status', function ($lead) use ($arrLeadStatusRekeyed) {
                return isset($arrLeadStatusRekeyed[$lead->lead_status])
                    ? '<span class="badge" style="background:' . $arrLeadStatusRekeyed[$lead->lead_status]->color_code . ';color:#fff">'
                        . $arrLeadStatusRekeyed[$lead->lead_status]->title . '</span>'
                    : '';
            })
      
    ->addColumn('created_at', function ($lead) {
    return $lead->created_at ? \Carbon\Carbon::parse($lead->created_at)->format('d/m/Y') : '';
})
->addColumn('updated_at', function ($lead) {
    return $lead->updated_at ? \Carbon\Carbon::parse($lead->updated_at)->format('d/m/Y') : '';
})

            ->addColumn('created_by', function ($lead) use ($arrUsersRekeyed) {
                return isset($arrUsersRekeyed[$lead->created_by])
                    ? $arrUsersRekeyed[$lead->created_by]->first_name . ' ' . $arrUsersRekeyed[$lead->created_by]->last_name
                    : '';
            })
                  ->addColumn('assigned_to', function ($lead) use ($arrUsersRekeyed) {
                return isset($arrUsersRekeyed[$lead->assigned_to])
                    ? $arrUsersRekeyed[$lead->assigned_to]->first_name . ' ' . $arrUsersRekeyed[$lead->assigned_to]->last_name
                    : '';
            })
            ->addColumn('actions', function ($lead) {
                return '<a href="/leads/' . $lead->id . '/edit" class="list-icons-item me-10"><i class="fa fa-edit"></i></a>
                        <a href="/leads/view?id=' . $lead->id . '" class="list-icons-item me-10"><i class="fa fa-eye"></i></a>
                        <a href="#" class="list-icons-item me-10 openLeadDelete" data-id="' . $lead->id . '"><i class="fa fa-trash-o"></i></a>';
            })
            ->rawColumns(['lead_type', 'lead_status', 'actions'])
            ->make(true);

    }
//dd($lead_status_count);
       
    // Normal page load: return view with dynamic headers
    return view("dashboard.crm-dashboard", ['view_on_leads' => $view_on_leads ?? [],'users' => $arrUsersRekeyed,"lead_status" => $lead_status,"lead_status_count" =>$lead_status_count,"leads" => $leads,  'users' => $arrUsersRekeyed,'arrLeadStatusRekeyed'=>$arrLeadStatusRekeyed,'filteredLeadStatus'=>$filteredLeadStatus,'sortedUsers'=>$sortedUsers,'record_count'=>$record_count]);
}        


    public function viewold(Request $request)
    {
        //dd($request->all());
        
        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $users = (array) $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }


        $arrUsersRekeyed = Helper::rekeyArray($users, 'id');

        //echo "<pre>";print_r($arrUsersRekeyed);die;
        
        $page=0;
        $upper_limit='';
        $urlpage = $request->page;
        if (!empty($urlpage) && $urlpage > 1)
        {
            $urlpage = $urlpage - 1;
            $lower_limit = $urlpage * 10;
        }
        else
        {
            $lower_limit = 0;
        }



        $body = array
        (
            'level' => Session::get('userLevel'),
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lead_status' => $request->lead_status,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'company_name' => $request->company_name,
            'assigned_to' => $request->assigned_to,
            'lead_type' => $request->lead_type,
            'phone_number' => $request->phone_number,
            'crm_id' => $request->crm_id,
            'dba' => $request->dba,
        );

            //echo "<pre>";print_r($body);die;

            $inherit_list = new InheritApiController;
            $extension_list = $inherit_list->getExtensionList();
    
    
            $errors = new MessageBag();
            /* list list */
            $map = [];
            $url = env('API_URL') . "extension-group-map";
            try
            {
                $response = Helper::GetApi($url);
                if ($response->success)
                {
                    $map = $response->data;
                    //echo"<pre>";print_r($map);die;
                }
                else
                {
                    foreach ( $response->errors as $key => $message )
                    {
                        $errors->add($key, $message);
                    }
                }
            }
            catch (RequestException $ex)
            {
                $errors->add("error", $ex->getMessage());
                return view("extension.extension-group", compact("errors", $errors));
            }
    
            /* close list */
            $title = "Group List | " . env('APP_NAME');
            $url = env('API_URL') . 'extension-group';
            $response = Helper::GetApi($url);
            if ($response->success) {
                $group = $response->data;
            } 
// Initialize variables
$group_ids = [];
$associated_extensions = [];

// Get the user role and extension from the session
$userRole = Session::get('role');
$userExtension = Session::get('extension'); 

// Apply the logic if the user role is manager
if ($userRole === 'manager' && !empty($userExtension)) {

   // Step 1: Find all group_ids for the manager's extension
   foreach ($map as $entry) {
       if ($entry->extension == $userExtension && $entry->is_deleted == 0) {
           // Ensure no duplicate group_ids are added
           if (!in_array($entry->group_id, $group_ids)) {
               $group_ids[] = $entry->group_id;
           }
       }
   }
   Log::info('Groups reached', ['group_ids' => $group_ids]);

   // Step 2: Collect all extensions associated with the found group_ids
   if (!empty($group_ids)) {
       foreach ($map as $entry) {
           // Check that the entry is not deleted and belongs to one of the collected group_ids
           if (in_array($entry->group_id, $group_ids) && $entry->is_deleted == 0) {
               $associated_extensions[] = $entry->user_id;
               Log::info('Added extension: ' . $entry->user_id);
           }
       }

       // Debugging: Log the final list of associated extensions
       Log::info('Associated extensions: ' . json_encode($associated_extensions));
   }
}

Log::info('reached group_id',['group_id'=>$group_ids]);
        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leads";
        try
        {
            $response = Helper::PostApi($url, $body);
           //echo "<pre>";print_r($response);die;
         
            if ($response->success)
            {
                // Apply the logic if the user role is manager
                $leads = $response->data;
                
                
          //echo "<pre>";print_r($leads);die;

                $record_count = $response->record_count;


            }

            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            // return view("leads.list", ["errors" => $errors]);
        }
         $view_on_leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-view-on-leads";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $view_on_leads = (array) $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $lead_status = (array) $response->data;
                $filteredLeadStatus = [];

foreach ($lead_status as $le) {
    // Assuming $lead is an object with a property named 'view_on_dashboard'
    if (isset($le->view_on_dashboard) && $le->view_on_dashboard == 1) {
        $filteredLeadStatus[] = $le;
    }
}
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }
        $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
        //echo "<pre>";print_r($url);die;

        $lead_status_count = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "dashboard-lead-status";
        //echo "<pre>";print_r($url);die;

        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $lead_status_count = (array)$response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("dashboard.crm-dashboard", ["errors" => $errors]);
        }
        //echo "<pre>";print_r($leads);die;

        if($request->submit_download == '1')  {
            return Excel::download(new LeadsExport($leads,$users,$lead_status), 'leads.xlsx');
            // return $this->downloadCSV($leads);
        }
        $sortedUsers = $this->groupAndSortUsers($users);
        return response()->json(["lead_status" => $lead_status,"lead_status_count" =>$lead_status_count,'view_on_leads'=>$view_on_leads,"leads" => $leads, "lower_limit" => $lower_limit, 'users' => $arrUsersRekeyed,'page' =>$page,'arrLeadStatusRekeyed'=>$arrLeadStatusRekeyed,'record_count'=>$record_count,'filteredLeadStatus'=>$filteredLeadStatus,'sortedUsers'=>$sortedUsers], 200);
        // return view("dashboard.crm-dashboard",['view_on_leads'=>$view_on_leads]);
    }
    
    private function groupAndSortUsers(array $users): Collection
    {
        $groupedUsers = collect($users)->groupBy(function ($user) {
            return strtoupper(substr($user->first_name, 0, 1));
        });

        $groupedUsers = $groupedUsers->map(function ($group) {
            return $group->sortBy('first_name');
        });

        $groupedUsers = $groupedUsers->sortKeys();

        return $groupedUsers->flatMap(function ($group) {
            return $group->values();
        });
    }
 
    private function downloadCSV($leads)
    {
        // Set the filename for the CSV file
        $filename_excel = 'Leads_' . date('Y-m-d') . ".csv";
    
        // Set the headers for the CSV download
        header("Content-Type: text/csv");
        header("Content-Disposition: attachment; filename=" . $filename_excel);
        header("Pragma: no-cache");
        header("Expires: 0");
    
        // Define the column headers for the CSV
        $columns = array('First Name', 'Last Name', 'Email', 'Mobile', 'Company Name');
        
        // Open output stream for writing to the CSV file
        $file = fopen('php://output', 'w');
    
        // Write the column headers to the CSV
        fputcsv($file, $columns);
    
        // Loop through the leads and write each lead's data to the CSV
        foreach ($leads as $lead) {
            // Assuming each $lead is an associative array with the appropriate keys
            $first_name = isset($lead->first_name) ? $lead->first_name : '-';
            $last_name = isset($lead->last_name) ? $lead->last_name : '-';
            $email = isset($lead->email) ? $lead->email : '-';
            $mobile = isset($lead->phone_number) ? $lead->phone_number : '-';
            $company_name = isset($lead->company_name) ? $lead->company_name : '-';
    
            // Write the lead's data to the CSV
            fputcsv($file, array($first_name, $last_name, $email, $mobile, $company_name));
        }
    
        // Close the output stream
        fclose($file);
        
        // Exit to prevent any further output
        exit();
    }
    
    public function viewNew(Request $request)
    {
        //dd($request->all());
        $users = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "users";
        try
        {
            $response = Helper::GetApi($url);

        //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $users = (array) $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }


        $arrUsersRekeyed = Helper::rekeyArray($users, 'id');

     // Default upper limit
    $upper_limit = 10;
  
    // Get selected value from filter
    $show = $request->input('show', 10);
        if ($show == 25 || $show == 50 || $show == 100) {
      $upper_limit = $show;
    }
  
    $urlpage = $request->page;
    
    $page=0;
    $lower_limit=0;
  
    if (!empty($urlpage) && $urlpage > 1)
    {
      $urlpage = $urlpage - 1;
      $lower_limit = $urlpage * $upper_limit;
    }
  
    if ($request->isMethod('post')) {
      $lower_limit = 0;
      $page=1;
    }
    $searchTerm = $request->input('search');
         if ($request->submit_download == 'excel') {

             $upper_limit='';
         }

        $body = array
        (
            'level' => Session::get('userLevel'),
            'start_date' => $request->start_date,
            'end_date' =>  $request->end_date,
            'lower_limit' => $lower_limit,
            'upper_limit' => $upper_limit,
            'id' => Session::get('id'),
            'lead_status' => $request->lead_status,
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'company_name' => $request->company_name,
            'assigned_to' => $request->assigned_to,
            'lead_type' => $request->lead_type,
            'phone_number' => $request->phone_number,
            'crm_id' => $request->crm_id,
            'dba' => $request->dba,
            'search' => $searchTerm,
        );

            //echo "<pre>";print_r($body);die;

            $inherit_list = new InheritApiController;
            $extension_list = $inherit_list->getExtensionList();
    
    
            $errors = new MessageBag();
            /* list list */
            $map = [];
            $url = env('API_URL') . "extension-group-map";
            try
            {
                $response = Helper::GetApi($url);
                if ($response->success)
                {
                    $map = $response->data;
                    //echo"<pre>";print_r($map);die;
                }
                else
                {
                    foreach ( $response->errors as $key => $message )
                    {
                        $errors->add($key, $message);
                    }
                }
            }
            catch (RequestException $ex)
            {
                $errors->add("error", $ex->getMessage());
                return view("extension.extension-group", compact("errors", $errors));
            }
    
            /* close list */
            $title = "Group List | " . env('APP_NAME');
            $url = env('API_URL') . 'extension-group';
            $response = Helper::GetApi($url);
            if ($response->success) {
                $group = $response->data;
            } 
// Initialize variables
$group_ids = [];
$associated_extensions = [];

// Get the user role and extension from the session
$userRole = Session::get('role');
$userExtension = Session::get('extension'); 

// Apply the logic if the user role is manager
if ($userRole === 'manager' && !empty($userExtension)) {

   // Step 1: Find all group_ids for the manager's extension
   foreach ($map as $entry) {
       if ($entry->extension == $userExtension && $entry->is_deleted == 0) {
           // Ensure no duplicate group_ids are added
           if (!in_array($entry->group_id, $group_ids)) {
               $group_ids[] = $entry->group_id;
           }
       }
   }
   Log::info('Groups reached', ['group_ids' => $group_ids]);

   // Step 2: Collect all extensions associated with the found group_ids
   if (!empty($group_ids)) {
       foreach ($map as $entry) {
           // Check that the entry is not deleted and belongs to one of the collected group_ids
           if (in_array($entry->group_id, $group_ids) && $entry->is_deleted == 0) {
               $associated_extensions[] = $entry->user_id;
               Log::info('Added extension: ' . $entry->user_id);
           }
       }

       // Debugging: Log the final list of associated extensions
       Log::info('Associated extensions: ' . json_encode($associated_extensions));
   }
}

Log::info('reached group_id',['group_id'=>$group_ids]);
        $leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "lead-new";
        try
        {
            $response = Helper::PostApi($url, $body);
           //echo "<pre>";print_r($response);die;
         
            if ($response->success)
            {
                // Apply the logic if the user role is manager
                $leads = $response->data;
                
                
          //echo "<pre>";print_r($leads);die;

                $record_count = $response->record_count;
                // if ($userRole === 'manager' && !empty($associated_extensions)) {
                //     $leads = array_filter($leads, function ($lead) use ($associated_extensions) {
                //         return in_array($lead->assigned_to, $associated_extensions);
                //     });
                // } else {
                //     $leads = $leads;
                // }
                //           echo "<pre>";print_r($leads);die;

          
            }

            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }

        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            // return view("leads.list", ["errors" => $errors]);
        }
         $view_on_leads = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-view-on-leads";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $view_on_leads = (array) $response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leads.list", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $lead_status = (array) $response->data;
                $filteredLeadStatus = [];

foreach ($lead_status as $le) {
    // Assuming $lead is an object with a property named 'view_on_dashboard'
    if (isset($le->view_on_dashboard) && $le->view_on_dashboard == 1) {
        $filteredLeadStatus[] = $le;
    }
}
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }
        $arrLeadStatusRekeyed = Helper::rekeyArray($lead_status, 'lead_title_url');
        //echo "<pre>";print_r($url);die;

        $lead_status_count = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "dashboard-lead-status";
        //echo "<pre>";print_r($url);die;

        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $lead_status_count = (array)$response->data;
            }
            else
            {
                foreach ($response->errors as $key => $message)
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("dashboard.crm-dashboard-new", ["errors" => $errors]);
        }
        //echo "<pre>";print_r($leads);die;

        if($request->submit_download == '1')  {
            return Excel::download(new LeadsExport($leads,$users,$lead_status), 'leads.xlsx');
            // return $this->downloadCSV($leads);
        }
        $sortedUsers = $this->groupAndSortUsers($users);

// Check if request is AJAX
if ($request->ajax()) {
    return response()->json([
        "lead_status" => $lead_status,
        "lead_status_count" => $lead_status_count,
        'view_on_leads' => $view_on_leads,
        "leads" => $leads,
        "record_count" => $record_count,
        "lower_limit" => $lower_limit,
        "page" => $page,
        "show" => $show,
        "searchTerm" => $searchTerm,
        'users' => $arrUsersRekeyed,
        'arrLeadStatusRekeyed' => $arrLeadStatusRekeyed,
        'filteredLeadStatus' => $filteredLeadStatus,
        'sortedUsers' => $sortedUsers,
    ], 200);
} else {
    return view("dashboard.crm-dashboard-new", [
        "lead_status" => $lead_status,
        "lead_status_count" => $lead_status_count,
        'view_on_leads' => $view_on_leads,
        "leads" => $leads,
        "record_count" => $record_count,
        "lower_limit" => $lower_limit,
        "page" => $page,
        "show" => $show,
        "searchTerm" => $searchTerm,
        'users' => $arrUsersRekeyed,
        'arrLeadStatusRekeyed' => $arrLeadStatusRekeyed,
        'filteredLeadStatus' => $filteredLeadStatus,
        'sortedUsers' => $sortedUsers,
    ]);
}
    }
 public function getLeadStatusChart(Request $request)
{
    $dashboard_data = [];
    $body = [
        'id' => Session::get('id'),
        'start_date' => $request->start_date,
        'end_date' => $request->end_date,
    ];

    $errors = new MessageBag();
    $url = env('API_URL') . "lead-status-chart";

    try {
        $response = Helper::PostApi($url, $body);

        if ($response->success) {
            $dashboard_data = $response->data;
        } else {
            foreach ($response->errors as $key => $message) {
                $errors->add($key, $message);
            }
        }
    } catch (RequestException $ex) {
        $errors->add("error", $ex->getMessage());
    }

    return response()->json([
        'success' => empty($errors->all()),
        'data' => $dashboard_data,
        'errors' => $errors->all()
    ]);
}


}


