<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use App\User;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Session;
use Illuminate\Support\Facades\Log;

class CrmDripCampaignController extends Controller
{

    public function index(Request $request)
    {
   
        $drip_campaigns = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "drip-campaigns";
        try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                $drip_campaigns = $response->data;
            } else {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("drip_campaigns.list", compact("errors", $errors));
        }
        $lead_status = [];
        $url = env('API_URL') . "leadStatus";
        
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
          if ($response->success) {
            $lead_status = $response->data;
          }
          else
          {
            foreach ( $response->errors as $key => $message ) {
              $errors->add($key, $message);
            }
          }
        }
    
        catch (RequestException $ex)
        {
          $errors->add("error", $ex->getMessage());
          return view("marketing_campaign.list", compact("errors", $errors));
        }
         /* email templates list */
      $email_templates = [];
      $url = env('API_URL') . "crm-email-templates";
      try
      {
        $response = Helper::GetApi($url);
      //echo "<pre>";print_r($response);die;
    
        if ($response->success) {
          $email_templates = $response->data;
        }
        else
        {
          foreach ( $response->errors as $key => $message ) {
            $errors->add($key, $message);
          }
        }
      }
    
      catch (RequestException $ex)
      {
        $errors->add("error", $ex->getMessage());
        return view("drip_campaigns.list", compact("errors", $errors));
      }
    
      /* close email templates */
        /* smtps list */
        $smtp_setting = [];
        $url = env('API_URL') . "crm-email-setting";
        
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
          if ($response->success) {
            $smtp_setting = $response->data;
          }
          else
          {
            foreach ( $response->errors as $key => $message ) {
              $errors->add($key, $message);
            }
          }
        }
    
        catch (RequestException $ex)
        {
          $errors->add("error", $ex->getMessage());
          return view("marketing_campaign.list", compact("errors", $errors));
        }
    
        /* close smtps */
        return view("drip_campaigns.list", compact("drip_campaigns","lead_status","email_templates","smtp_setting"));
    }



    public function show(Request $request, int $id)
    { /* list list */
      $list = [];
      $url = env('API_URL') . "list";
      
      try
      {
          $response = Helper::PostApi($url);
          //echo "<pre>";print_r($response);die;
        if ($response->success) {
          $list = $response->data;
        }
        else
        {
          foreach ( $response->errors as $key => $message ) {
            $errors->add($key, $message);
          }
        }
      }
      catch (RequestException $ex)
      {
        $errors->add("error", $ex->getMessage());
        return view("drip_campaigns.list", compact("errors", $errors));
      }
    
      /* close list */
      /* email templates list */
      $email_templates = [];
      $url = env('API_URL') . "crm-email-templates";
      try
      {
        $response = Helper::GetApi($url);
      //echo "<pre>";print_r($response);die;
    
        if ($response->success) {
          $email_templates = $response->data;
        }
        else
        {
          foreach ( $response->errors as $key => $message ) {
            $errors->add($key, $message);
          }
        }
      }
    
      catch (RequestException $ex)
      {
        $errors->add("error", $ex->getMessage());
        return view("drip_campaigns.list", compact("errors", $errors));
      }
    
      /* close email templates */
        /* smtps list */
        $smtp_setting = [];
        $url = env('API_URL') . "crm-email-setting";
        
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
          if ($response->success) {
            $smtp_setting = $response->data;
          }
          else
          {
            foreach ( $response->errors as $key => $message ) {
              $errors->add($key, $message);
            }
          }
        }
    
        catch (RequestException $ex)
        {
          $errors->add("error", $ex->getMessage());
          return view("marketing_campaign.list", compact("errors", $errors));
        }
    
        /* close smtps */
        /*lead_status*/
          $lead_status = [];
          $url = env('API_URL') . "leadStatus";
          
          try
          {
              $response = Helper::GetApi($url);
              //echo "<pre>";print_r($response);die;
            if ($response->success) {
              $lead_status = $response->data;
            }
            else
            {
              foreach ( $response->errors as $key => $message ) {
                $errors->add($key, $message);
              }
            }
          }
      
          catch (RequestException $ex)
          {
            $errors->add("error", $ex->getMessage());
            return view("marketing_campaign.list", compact("errors", $errors));
          }
      
      $marketing_campaign = null;
      $errors = new MessageBag();
      try
      {
        $url = env('API_URL') . "drip-campaigns/$id";
        $response = Helper::GetApi($url, [], true);

        if ($response["success"])
        {
          $drip_campaign = $response["data"];
          //echo "<pre>";print_r($drip_campaign);die;

        }
        else
        {
          foreach ( $response["errors"] as $key => $message )
          {
            $errors->add($key, $message);
          }
          //return view("marketing_campaign.edit")->withErrors($errors);
          return $errors;
        }
      }
      catch (RequestException $ex)
      {
        $errors->add("error", $ex->getMessage());
        //return view("marketing_campaign.edit")->withErrors($errors);
        return $errors;
      }
      return view("drip_campaigns.edit")->with(["drip_campaign" => $drip_campaign,"list"=>$list,"email_templates"=>$email_templates,"smtp_setting"=>$smtp_setting,"lead_status"=>$lead_status,"schedule" => $drip_campaign['schedule']]);
    }

function add(Request $request){    
   /* list list */
  $list = [];
  $url = env('API_URL') . "list";
  
  try
  {
      $response = Helper::PostApi($url);
      //echo "<pre>";print_r($response);die;
    if ($response->success) {
      $list = $response->data;
    }
    else
    {
      foreach ( $response->errors as $key => $message ) {
        $errors->add($key, $message);
      }
    }
  }
  catch (RequestException $ex)
  {
    $errors->add("error", $ex->getMessage());
    return view("drip_campaigns.list", compact("errors", $errors));
  }

  /* close list */
  /* email templates list */
  $email_templates = [];
  $url = env('API_URL') . "crm-email-templates";
  try
  {
    $response = Helper::GetApi($url);
  //echo "<pre>";print_r($response);die;

    if ($response->success) {
      $email_templates = $response->data;
    }
    else
    {
      foreach ( $response->errors as $key => $message ) {
        $errors->add($key, $message);
      }
    }
  }

  catch (RequestException $ex)
  {
    $errors->add("error", $ex->getMessage());
    return view("drip_campaigns.list", compact("errors", $errors));
  }

  /* close email templates */
    /* smtps list */
    $smtp_setting = [];
    $url = env('API_URL') . "crm-email-setting";
    
    try
    {
        $response = Helper::GetApi($url);
        //echo "<pre>";print_r($response);die;
      if ($response->success) {
        $smtp_setting = $response->data;
      }
      else
      {
        foreach ( $response->errors as $key => $message ) {
          $errors->add($key, $message);
        }
      }
    }

    catch (RequestException $ex)
    {
      $errors->add("error", $ex->getMessage());
      return view("marketing_campaign.list", compact("errors", $errors));
    }

    /* close smtps */
    /*lead_status*/
      $lead_status = [];
      $url = env('API_URL') . "leadStatus";
      
      try
      {
          $response = Helper::GetApi($url);
          //echo "<pre>";print_r($response);die;
        if ($response->success) {
          $lead_status = $response->data;
        }
        else
        {
          foreach ( $response->errors as $key => $message ) {
            $errors->add($key, $message);
          }
        }
      }
  
      catch (RequestException $ex)
      {
        $errors->add("error", $ex->getMessage());
        return view("marketing_campaign.list", compact("errors", $errors));
      }
  return view('drip_campaigns.add',compact("list","email_templates","smtp_setting","lead_status"));
}
    function addNew(Request $request)
    {
     
      $this->validate($request, [
        'title' => 'required|string|max:255',
        'description' => 'required|string',
        'send' => 'required',
        'email_template_id' => 'required',
        'email_setting_id' => 'required',
        'run_time' => 'required',
        'created_by' => 'required'
      ]);
      $errors = new MessageBag();
      try
      {
        $url = env('API_URL') . "drip-email-template";
        $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
        if ($response->success)
        {
          session()->flash("success", "Drip Campaign Added");
          return redirect("drip-campaigns");
        }
        else
        {
          foreach ( $response->errors as $key => $messages )
          {
            if (is_array($messages))
            {
              foreach ( $messages as $index => $message )
                $errors->add("$key.$index", $message);
            }
            else
            {
              $errors->add($key, $messages);
            }
          }
          return redirect()->back()->withInput()->withErrors($errors);
        }
      }
      catch (RequestException $ex)
      {
        $errors->add("error", $ex->getMessage());
        return redirect()->back()->withInput()->withErrors($errors);
      }
    
    }

    private function getBuildBody(Request $request)
    {
        $body = [
            "title" => trim($request->get("title")),
            "description" => trim($request->get("description")),
            "list_id" => trim($request->get("list_id")),
            "list_column_name" => trim($request->get("list_column_name")),
            "run_time" => $request->get('run_time'),
            "send" => trim($request->get("send")),
            "email_template_id" => trim($request->get("email_template_id")),
            "email_setting_id" => trim($request->get("email_setting_id")),
            "created_by" => trim($request->get("created_by")),
            "lead_status_id" => trim($request->get("lead_status_id")),
            "schedule" => trim($request->get("run_time_id")),
            "schedule_day" => trim($request->get("schedule_day")),

        ];

        return $body;
    }


    public function update(Request $request, int $id)
    {
     
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "drip-campaigns/$id";
            $response = Helper::PostApi($url, $this->getBuildBody($request));
             //echo "<pre>";print_r($response);die;
            if (!$response->success) {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Drip Campaign updated");
        return redirect()->back();
    }
    public function updateDripStatus($id,$status)
    {
      $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'listId' => $id,
        'status' => $status,
      );
      
      $url = env('API_URL') . 'status-update-drip';
      try
      {
        $list = Helper::PostApi($url, $body);
        Log::info('reached drip status',["list"=>$list]);
            //echo"<pre>";print_r($list);die;
  
            // Log::debug('API Response', ['response' => $delete_list]);
            if ($list->success == 'true')
            {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "true", 'message' => $list->message));
            }
            if ($list->success == 'false') {
                //return redirect('/list')->withSuccess($delete_list->message);
                echo json_encode(array('status' => "false", 'message' => $list->message));
            }
        } catch (BadResponseException $e) {
            return back()->with('message', "Error code - (edit-list): Oops something went wrong :( Please contact your administrator.)");
        }
    }
}

