<?php

namespace App\Http\Controllers;
use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use App\Mail\TestMail;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class CrmEmailSettingController extends Controller
{
    public function index(Request $request)
    {
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-email-setting";

        try {

            $response = Helper::GetApi($url);
             //echo "<pre>";print_r($response);die;
            if ($response->success) {
                $crm_system = $response->data;
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }

        return view("crm-email-setting.list",['crm_system'=>$crm_system]);
    }


    public function add(Request $request)
    {
        $errors = new MessageBag();    
        if((!empty($request->online_id)) || (!empty($request->notification_id)) || (!empty($request->submission_id)) || (!empty($request->marketing_campaigns_id)))
        {
            if((!empty($request->online_id)) && $request->mail_type == 'online application')
            {
                $email_setting_id = $request->online_id;
            }
            else
            if(!empty($request->notification_id) && $request->mail_type == 'notification')
            {
                $email_setting_id = $request->notification_id;
            }
            else
            if(!empty($request->submission_id) && $request->mail_type == 'submission')
            {
                $email_setting_id = $request->submission_id;
            }
            else
            if(!empty($request->marketing_campaigns_id) && $request->mail_type == 'marketing_campaigns')
            {
                $email_setting_id = $request->marketing_campaigns_id;
            }
            try {
                $url = env('API_URL') . "update-crm-email-setting/$email_setting_id";
                $response = Helper::PostApi($url, $this->getBuildBody($request));
                if (!$response->success) {
                    foreach ( $response->errors as $key => $messages )
                    {
                        if (is_array($messages))
                        {
                            foreach ( $messages as $index => $message )
                                $errors->add("$key.$index", $message);
                        }
                        else
                        {
                            $errors->add($key, $messages);
                        }
                    }

                    return redirect()->back()->withInput($request->input())->withErrors($errors);
                }
            } catch (RequestException $ex) {
                $errors->add("error", $ex->getMessage());
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
            session()->flash("success", "System Setting updated");
            return redirect()->back();
        }

        try {

            $url = env('API_URL') . "crm-email-setting";
            $response = Helper::RequestApi($url, "POST", $this->getBuildBody($request), "json");
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                session()->flash("success", "Email Setting Added");
                return redirect("/crm-email-setting");
            }
            else
            {
                foreach ( $response->errors as $key => $messages )
                {
                    if (is_array($messages))
                    {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }

    private function getBuildBody(Request $request)
    {

        $body = [
            "mail_driver" => $request->get("mail_driver"),
            "mail_username" => $request->get("mail_username"),
            "mail_password" => $request->get("mail_password"),
            "sender_email" => $request->get("sender_email"),
            "send_email_via" => $request->get("send_email_via"),
            "sender_name" => $request->get("sender_name"),
            "mail_type" => $request->get("mail_type")
        ];

        return $body;
    }

    public function checkCrmSMTPSetting(Request $request)
    {
        Log::info('Raw Request Data:', ['raw_request' => $request->getContent()]);
        Log::info('Request data:', ['request' => $request->all()]);

        if ($request->get('mail_driver') === "Sendgrid") {
            $mail_host = "smtp.sendgrid.net";
        }
        elseif(($request->get('mail_driver') === "Zoho") ){
            $mail_host = "smtp.zoho.com";
        }
        elseif(($request->get('mail_driver') === "Google") ){
            $mail_host = "smtp.gmail.com";
        }

        $config = array(             
            "driver"=> "smtp",
            "host"=>  $mail_host,
            "port"=> 587,
            "encryption"=>"tls",
            "username"=> $request->get('mail_username'),
            "password"=> $request->get('mail_password'),
        );


        try {
            $toEmail = session()->get('emailId');
            
            if($request->get('send_email_via') =='custom')
            {
                $config['address'] = $request->get('sender_email');
                $config['name'] = $request->get('sender_name');

            }
            /// for user_email
            else
            {
                $config['address'] = $toEmail;
                $config['name'] = 'Test Email';
            }

            $tempConfig = Config::get("mail");

            //echo "<pre>";print_r($config);die;
            Config::set('mail', $config);
            Mail::to($toEmail)->sendNow(new TestMail([
                'address' => $config['address'],
                'name' => $config['name']
             ], 'Email Setting Test'));
             
             return response()->json(["success" => true]);
        } catch (\Throwable $throwable) {
             Log::error("checkSMTPSetting", [
                 "message" => $throwable->getMessage(),
                 "file" => $throwable->getFile(),
                 "line" => $throwable->getLine()
             ]);
             return response()->json(["success" => false, "message" => $throwable->getMessage()]);
        }
    }
}