<?php
namespace App\Http\Controllers;
use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Mail;
use App\Mail\TestMail;
use App\User;




class CrmSmsTemplateController extends Controller
{
    public function index(Request $request)
    {
        $sms_templates = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-sms-template";
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                $sms_templates = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("crm-sms-template.list", ["errors"=> $errors]);
        }

        //echo "<pre>";print_r($smtp_setting);die;
        return view("crm-sms-template.list",["sms_templates"=> $sms_templates]);
    }

    public function showNew(Request $request)
    {

        $template_types = [];
        $errors = new MessageBag();
        $label_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $label_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("configuration.crm-label", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        
        try
        {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;
            if ($response->success)
            {
                $lead_status = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leadstatus.list", ["errors" => $errors]);
        }

        $users = new User();
        $user_column = $users->getTableColumns();

        return view("crm-sms-template.add")->with(['template_types' => $template_types, 'lead_status' => $lead_status,'label_list' => $label_list,'user_column' => $user_column]);
    }

    public function add(Request $request)
    {
        $this->validate($request, [
            'template_name' => 'required|string|max:255',
            'template_html' => 'required|string',
        ]);

        //echo "<pre>";print_r($this->getBuildBody($request));die;
        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "crm-add-sms-template";
            $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
        //echo "<pre>";print_r($response);die;

            if ($response->success)
            {
                session()->flash("success", "Sms Template Added");
                return redirect("/crm-sms-templates");
            }
            else
            {
                foreach ( $response->errors as $key => $messages )
                {
                    if (is_array($messages))
                    {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }


    public function show(Request $request, int $id)
    {
        $sms_template = null;
        $errors = new MessageBag();
        try {
            $url = env('API_URL') . "crm-sms-template/$id";
            $response = Helper::GetApi($url, [], true);

            if ($response["success"]) {
                $sms_template = $response["data"];
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message)
                            $errors->add("$key.$index", $message);
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return view("crm-sms-template.edit")->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("crm-sms-template.edit")->withErrors($errors);
        }

        $label_list = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-labels";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $label_list = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("configuration.crm-label", ["errors" => $errors]);
        }
        $lead_status = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "leadStatus";
        try
        {
            $response = Helper::GetApi($url);
            if ($response->success)
            {
                $lead_status = $response->data;
            }
            else
            {
                foreach ( $response->errors as $key => $message )
                {
                    $errors->add($key, $message);
                }
            }
        }
        catch (RequestException $ex)
        {
            $errors->add("error", $ex->getMessage());
            return view("leadstatus.list", ["errors" => $errors]);
        }

        $errors = new MessageBag();

        $users = new User();
        $user_column = $users->getTableColumns();

        return view("crm-sms-template.edit")->with([ 'sms_template'=>$sms_template,'lead_status' => $lead_status,'label_list' => $label_list,'user_column' => $user_column]);
    }

    public function update(Request $request, int $id)
    {
        $this->validate($request, [
            'template_name' => 'required|string|max:255',
            'template_html' => 'required|string',
        ]);

        $errors = new MessageBag();
        try
        {
            $url = env('API_URL') . "crm-sms-template/$id";
            $response = Helper::PostApi($url, $this->getBuildBody($request));
            //echo "<pre>";print_r($response);die;

            if (!$response->success) {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        session()->flash("success", "Sms Template Updated");
        return redirect("/crm-sms-templates");
    }

    public function delete(Request $request, $id)
    {
        $url = env('API_URL') . "crm-delete-sms-template/$id";
        $response = Helper::RequestApi($url, "GET");

        if ($response->success)
        {
            session()->flash("success", $response->message);
            return redirect("/crm-sms-templates");
        }
        else
        {
            session()->flash("message", $response->message);
            return redirect("/crm-sms-templates");

        }
    }


    public function changeSmsTemplateStatus($sms_template_id = "",  $status = "")
    {
        $body = array('sms_template_id' => $sms_template_id,'status' => $status);
        $url = env('API_URL') . 'crm-change-sms-template-status';
        $response = Helper::PostApi($url, $body);
        //echo "<pre>";print_r($body);die;
        if ($response->success)
        {
            session()->flash("success", $response->message);
            echo json_encode(array('status' => "true", 'message' =>  $response->message));
        }
        else
        {
            session()->flash("message", $response->message);
            echo json_encode(array('status' => "false", 'message' =>  $response->message));
        }
    }

    private function getBuildBody(Request $request)
    {
        $body =[
            "template_name" => trim(($request->get("template_name"))),
            "template_html" => trim(($request->get("template_html"))),
            "lead_status" => ($request->get("lead_status")),


        ];
        return $body;
    }

   
}


