<?php

namespace App\Http\Controllers;

use Session;
use Pusher\Pusher;
use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;

class CrmSystemSettingController extends Controller
{
    public function index(Request $request)
    {
        $crm_system = [];
        $errors = new MessageBag();
        $url = env('API_URL') . "crm-system-setting";
        try {
            $response = Helper::GetApi($url);
            // echo "<pre>";print_r($response);die;

            if ($response->success) {
                $crm_system = $response->data;
              

            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("labels.list", ["errors" => $errors]);
        }


        return view("crm-system-setting.add",['crm_system'=>$crm_system]);
    }
    public function add(Request $request)
    {
        $errors = new MessageBag();
        $logo = $request->file('logo');
    
        // Check if the 'logo' file is present in the request
        if (!empty($logo)) {
            if ($request->hasFile('logo')) {
                $existingLogoPath = public_path("logo/{$logo->getClientOriginalName()}");
                if (file_exists($existingLogoPath)) {
                    unlink($existingLogoPath);
                }
            }
            
            // Validate the 'logo' file
            $request->validate([
                'logo' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
            ]);
    
            // Move the uploaded 'logo' file to the desired location
            $imageName = $logo->getClientOriginalName();
            $logo->move(public_path('logo'), $imageName);
        } else {
            $imageName = null;
        }
    
        try {
            $url = env('API_URL') . "crm-system-setting";
            $response = Helper::RequestApi($url, "POST", $this->getBuildBody($request, $imageName), "json");
            //echo "<pre>";print_r($response);die;

            if ($response->success) {
                session()->flash("success", "System Setting Added");
                return redirect("/crm-system-setting");
            } else {
                foreach ($response->errors as $key => $messages) {
                    if (is_array($messages)) {
                        foreach ($messages as $index => $message) {
                            $errors->add("$key.$index", $message);
                        }
                    } else {
                        $errors->add($key, $messages);
                    }
                }
                return redirect()->back()->withInput()->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput()->withErrors($errors);
        }
    }
    
   
    
    public function update(Request $request)
    {
        $system_id = $request->id;
        $errors = new MessageBag();
        $logo = $request->file('logo');
        
    // Check if the 'logo' file is present in the request
    if (!empty($logo)) {
        if ($request->hasFile('logo')) {
            $existingLogoPath = public_path("logo/{$logo->getClientOriginalName()}");
            if (file_exists($existingLogoPath)) {
                unlink($existingLogoPath);
            }
        }

        // Validate the 'logo' file
        $request->validate([
            'logo' => 'mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        // Move the uploaded 'logo' file to the desired location
        $imageName = $logo->getClientOriginalName();
        $logo->move(public_path('logo'), $imageName);
    } else {
        // If 'logo' file is not present, use the existing image name or provide a default value
        $imageName = null;
    }
                try {
            $url = env('API_URL') . "update-system-setting/$system_id";
            $response = Helper::PostApi($url, $this->getBuildBody($request,$imageName));
            //echo "<pre>";print_r($response);die;

            if (!$response->success) {
                foreach ( $response->errors as $key => $messages )
                {
                    if (is_array($messages))
                    {
                        foreach ( $messages as $index => $message )
                            $errors->add("$key.$index", $message);
                    }
                    else
                    {
                        $errors->add($key, $messages);
                    }
                }
    
              
    
                return redirect()->back()->withInput($request->input())->withErrors($errors);
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return redirect()->back()->withInput($request->input())->withErrors($errors);
        }
        
        session()->flash("success", "Company Details has been updated");
        return redirect()->back();
    }
    
    private function getBuildBody(Request $request, $imageName)
    {
        $body = [
            "company_name" => trim(ucwords($request->get("company_name"))),
            "company_address" => trim(ucwords($request->get("company_address"))),
            "company_phone" => trim(ucwords($request->get("company_phone"))),
            "company_email" => trim(ucwords($request->get("company_email"))),
            "state" => trim(ucwords($request->get("state"))),
            "city" => trim(ucwords($request->get("city"))),
            "zipcode" => trim(ucwords($request->get("zipcode"))),
            "logo" => $imageName,
            "company_domain"=>$request->get('company_domain'),
        ];
    
        return $body;
    }
}