<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use App\User;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;

class DripCampaignScheduleController extends Controller
{

   
    function addDripSchedule(Request $request)
    {

        $this->validate($request, [
            'campaign_id' => 'required',
            'send' => 'required',
            'email_template_id' => 'required',
            'email_setting_id' => 'required',
            'run_time' => 'required',
            'created_by' => 'required'

        ]);

        $url = env('API_URL') . "drip-campaign-schedule";
        $response = Helper::RequestApi($url, "PUT", $this->getBuildBody($request), "json");
        //echo "<pre>";print_r($response);die;

        return response()->json($response);
    }

    private function getBuildBody(Request $request)
    {
        $body = [
            "campaign_id" => trim($request->get("campaign_id")),
            "list_id" => trim($request->get("list_id")),
            "list_column_name" => trim($request->get("list_column_name")),
            "run_time" => $request->get('run_time'),
            "send" => trim($request->get("send")),
            "email_template_id" => trim($request->get("email_template_id")),
            "email_setting_id" => trim($request->get("email_setting_id")),
            "created_by" => trim($request->get("created_by")),
            "lead_status_id" => trim($request->get("lead_status_id")),

        ];

        return $body;
    }

   
}

