<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use App\User;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Session;
use MaddHatter\LaravelFullcalendar\Facades\Calendar; // Use the fully qualified namespace
use Illuminate\Support\Facades\Log;

class EventController extends Controller
{
  
    
    public function index(Request $request)
    {
        $events=[];
        $calendar=[];
        $eventId = null; 
        $errors = new MessageBag();
        $url = env('API_URL') . "calender-events";
             try {
            $response = Helper::GetApi($url);
            //echo "<pre>";print_r($response);die;


           

            if ($response->success) {
                $event=[];
            $events=$response->data;
            foreach ($events as $row) {
                 $eventId = $row->id;
           

            // echo "<pre>";print_r($eventId);die;
                $endDate = $row->end_date . " 24:00:00"; // Fixed the comparison operator and added a space before the time
                $event[] = \MaddHatter\LaravelFullcalendar\Facades\Calendar::event( // Using the fully qualified namespace
                    $row->title,
                    false,
                    new \DateTime($row->start_date),
                    new \DateTime($row->end_date),
                    $row->id,
                    [
                        'color' => $row->color,
                    ]
                );
            }
            $calendar = \MaddHatter\LaravelFullcalendar\Facades\Calendar::addEvents($event);
                     //echo "<pre>";print_r($event);die;

            } else {
                foreach ( $response->errors as $key => $message ) {
                    $errors->add($key, $message);
                }
            }
        } catch (RequestException $ex) {
            $errors->add("error", $ex->getMessage());
            return view("calender.eventPage", compact("errors", $errors));
        }
    return view('calender.eventPage',compact('events','calendar','eventId'));
    }
    
   
    function add(Request $request)
    {

            $url = env('API_URL') . 'add-events';
       
            $body = array(
                'id' => Session::get('id'),
                'token' => Session::get('tokenId'),
                'title' => $request->title,
                'color' => $request->color,
                'start_date' => $request->start_date,
                'end_date' => $request->end_date,

            );
            
            try {
                $response = Helper::RequestApi($url, "POST", $body, "json");
                //echo "<pre>";print_r($response);die;
                if ($response->success == 'true') {


              
                    return redirect('/events')->withSuccess($response->message);
                }

                if ($response->success == 'false') {
                    return back()->withSuccess($response->message);
                }
            } catch (BadResponseException   $e) {
                return back()->with('message', "Error code - (add-campaign): Oops something went wrong :( Please contact your administrator.)");
            } catch (RequestException $ex) {

                return back()->with('message', "Error code - (add-campaign): Oops something went wrong :( Please contact your administrator.)");
            }
        
    }

 public function display()
 {
    $events=[];
    $errors = new MessageBag();
    
    $url = env('API_URL') . "calender-events";
         try 
    {
        $response = Helper::GetApi($url);
        //echo "<pre>";print_r($response);die;


        if ($response->success) 
        {
        $events=$response->data;

  
       }
    }
     catch (RequestException $ex) 
    {
        $errors->add("error", $ex->getMessage());
    }

return view('calender.displayEvents',compact('events'));
 }

 public function update(Request $request,$id){
    $url = env('API_URL') . 'edit-events';
    //echo "<pre>";print_r($url);die;
    $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'event_id' => $id,
        'title'=>$request->input('title'),
        'color'=>$request->input('color'),
        'start_date'=>$request->input('start_date'),
        'end_date'=>$request->input('end_date'),

    );
    //echo "<pre>";print_r($body);die;

    try {
        $ext_group = Helper::RequestApi($url, "POST", $body, "json");
    //echo "<pre>";print_r($ext_group);die;
        if ($ext_group->success == 'true') {
            // echo "<pre>";print_r($group);die;
            //return back()->withSuccess($result->message);
            return back()->withSuccess($ext_group->message);
        }

        if ($ext_group->success == 'false') {
            return redirect('/events');
            //return back()->withSuccess($ext_group->message);
        }
    } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    }

}
 public function delete($id){

    $url = env('API_URL') . 'delete-events';
    // echo "<pre>";print_r($body);die;
    $body = array(
        'id' => Session::get('id'),
        'token' => Session::get('tokenId'),
        'event_id' => $id,
    );
    try {
        $ext_group = Helper::PostApi($url,$body);
        //echo "<pre>";print_r($ext_group);die;
        if ($ext_group->success == 'true') {
            // echo "<pre>";print_r($group);die;
            //return back()->withSuccess($result->message);
            return back()->withSuccess($ext_group->message);
        }

        if ($ext_group->success == 'false') {
            return redirect('/events');
            //return back()->withSuccess($ext_group->message);
        }
    } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    }
 }
 public function show($id){

    $url = env('API_URL') . "edit-events/$id";
    //echo "<pre>";print_r($url);die;

    try {
        $ext_group = Helper::GetApi($url);
        //echo "<pre>";print_r($ext_group);die;
        if ($ext_group->success == 'true') {
            $event=$ext_group->data;
            // echo "<pre>";print_r($group);die;
            //return back()->withSuccess($result->message);
            return response()->json($event);
        }

        if ($ext_group->success == 'false') {
            return redirect('/events');
            //return back()->withSuccess($ext_group->message);
        }
    } catch (BadResponseException   $e) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    } catch (RequestException $ex) {
        return back()->with('message', "Error code - (edit-campaign): Oops something went wrong :( Please contact your administrator.)");
    }
 }
}

