<?php

namespace App\Http\Controllers;

use App\Helper\Helper;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;

class FCMController extends Controller
{
    public function saveFcmToken(Request $request)
    {
        $errors = new MessageBag();

        // Prepare payload
        $payload = [
            'token' => $request->input('token'),
        ];

        $url = env('API_URL') . "save-fcm-token";
        try {
            $response = Helper::PostApi($url, $payload);

            if ($response->success) {
                return response()->json(['message' => 'Token sent to backend successfully']);
            } else {
                foreach ($response->errors as $key => $message) {
                    $errors->add($key, $message);
                }
            }
        } catch (\Throwable $ex) {
            $errors->add("error", $ex->getMessage());
        }

        return response()->json(['errors' => $errors->all()], 400);
    }

    public function sendTestNotificationView()
    {
        return view('test-web-notification');
    }

    public function sendTestNotification(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'title' => 'nullable|string|max:255',
            'body'  => 'nullable|string|max:1000',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors'  => $validator->errors(),
            ], 422);
        }

        $payload = [
            'title' => $request->input('title', 'Test Notification'),
            'body'  => $request->input('body', 'This is a test message.'),
        ];

        try {
            $url = env('API_URL') . '/test-notification';
            $response = Helper::PostApi($url, $payload);

            if ($response->success ?? false) {
                return response()->json([
                    'success' => true,
                    'message' => 'Notification sent successfully.',
                ]);
            }

            return response()->json([
                'success' => false,
                'errors'  => $response->errors ?? ['Unknown error occurred'],
            ], 400);
        } catch (\Throwable $e) {
            return response()->json([
                'success' => false,
                'errors'  => ['exception' => $e->getMessage()],
            ], 500);
        }
    }
}
